/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.stats;

import uk.org.retep.util.cluster.ClusteredTime;

public class Statistic<T>
implements Comparable<Statistic<T>> {
    private final long timestamp;
    private final T value;

    public Statistic(T value) {
        this(ClusteredTime.currentClusterTimeMillis(), value);
    }

    public Statistic(long timestamp, T value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Statistic other = (Statistic)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return this.value == other.value || this.value != null && this.value.equals(other.value);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (int)(this.timestamp ^ this.timestamp >>> 32);
        hash = 67 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(Statistic<T> b) {
        long bTimestamp = b.timestamp;
        return this.timestamp < bTimestamp ? -1 : (this.timestamp == bTimestamp ? 0 : 1);
    }
}

