/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.list;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import uk.org.retep.util.collections.list.ListFacade;

public class RollingList<T>
extends ListFacade<T>
implements Serializable {
    private static final long serialVersionUID = -4206106764947365342L;
    private int capacity;

    public RollingList(int capacity) {
        super(new LinkedList());
        this.capacity = capacity;
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be >= 1");
        }
    }

    protected void fix() {
        while (this.size() > this.capacity) {
            this.list.remove(0);
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be >= 1");
        }
        this.capacity = capacity;
        this.fix();
    }

    @Override
    public boolean add(T e) {
        boolean ret = super.add(e);
        this.fix();
        return ret;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.fix();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean ret = super.addAll(c);
        this.fix();
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean ret = super.addAll(index, c);
        this.fix();
        return ret;
    }

    @Override
    public T set(int index, T element) {
        T ret = super.set(index, element);
        this.fix();
        return ret;
    }
}

