/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.classloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import uk.org.retep.util.classloader.CachingInputStreamClassLoader;
import uk.org.retep.util.io.FileUtils;

public class DirectoryClassLoader
extends CachingInputStreamClassLoader {
    private final File directory;

    public DirectoryClassLoader(String directory) {
        this(new File(directory));
    }

    public DirectoryClassLoader(File directory) {
        this.directory = directory;
    }

    public DirectoryClassLoader(String directory, ClassLoader parent) {
        super(parent);
        this.directory = new File(directory);
    }

    public DirectoryClassLoader(File directory, ClassLoader parent) {
        super(parent);
        this.directory = directory;
    }

    private File getClassFile(String classname) {
        String filename = classname.replace('.', File.separatorChar) + ".class";
        return new File(this.directory, filename);
    }

    @Override
    protected byte[] readBytes(String className) throws IOException {
        return FileUtils.readBytes(this.getClassFile(className));
    }

    @Override
    protected URL findResource(String name) {
        File file = new File(this.directory, name);
        FileUtils.assertFileInsideDirectory(this.directory, file);
        if (file.exists() && file.canRead()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }
}

