/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.app;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public final class ApplicationUtil {
    private ApplicationUtil() {
    }

    public static URL getJarURL(Class<?> clazz) throws MalformedURLException {
        URL classURL = clazz.getResource(clazz.getSimpleName() + ".class");
        if (classURL == null) {
            return null;
        }
        String path = classURL.toString();
        int i = path.indexOf(33);
        if (i > -1) {
            path = path.substring(0, i);
        }
        if (path.startsWith("jar:")) {
            path = path.substring(4);
        }
        return new URL(path);
    }

    public static File getJarFile(Class<?> clazz) {
        try {
            URL jarURL = ApplicationUtil.getJarURL(clazz);
            if (jarURL != null) {
                return new File(jarURL.getPath()).getAbsoluteFile();
            }
            return null;
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static File getApplicationDirectory(Class<?> clazz) {
        File jarFile = ApplicationUtil.getJarFile(clazz);
        if (jarFile == null) {
            return null;
        }
        if ((jarFile = jarFile.getParentFile()) != null && "lib".equals(jarFile.getName())) {
            jarFile = jarFile.getParentFile();
        }
        return jarFile;
    }

    public static URL getApplicationDirectoryURL(Class<?> clazz) {
        File dir = ApplicationUtil.getApplicationDirectory(clazz);
        try {
            return dir == null ? null : dir.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }
}

