/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import uk.org.retep.swing.model.AbstractModel;

public class EnumModel<T extends Renderable>
extends AbstractModel<T> {
    private T[] values;

    public EnumModel(T[] values) {
        this((Renderable[])values, (Renderable)values[0]);
    }

    public EnumModel(T[] values, T defaultValue) {
        super(defaultValue);
        this.values = values;
    }

    @Override
    public ListCellRenderer getRenderer() {
        return new EnumRenderer((Renderable)this.getDefaultValue());
    }

    @Override
    public int getSize() {
        return this.values.length;
    }

    @Override
    public Object getElementAt(int index) {
        return this.values[index];
    }

    public Object select(String name) {
        Object selected = null;
        if (name != null) {
            for (T v : this.values) {
                if (!name.equals(v.toString())) continue;
                selected = v;
                break;
            }
        }
        return selected;
    }

    public static interface Renderable<T> {
        public String getDescription();

        public void render(Graphics2D var1, int var2, int var3);
    }

    private class EnumRenderer
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = -7200159879726204139L;
        private Map<T, ImageIcon> cache = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EnumRenderer(Renderable<T> defaultValue) {
            this.setOpaque(false);
            for (Renderable value : EnumModel.this.values) {
                BufferedImage img = new BufferedImage(20, 20, 5);
                Graphics2D g = img.createGraphics();
                try {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(Color.white);
                    g.fillRect(0, 0, 20, 20);
                    g.setBackground(Color.white);
                    g.setColor(Color.black);
                    value.render(g, 20, 20);
                }
                finally {
                    g.dispose();
                }
                this.cache.put(value, new ImageIcon(img));
            }
        }

        private T getValue(Object value) {
            return (Renderable)value;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.setText("");
                this.setIcon(null);
            } else {
                Object end = this.getValue(value);
                this.setText(end.getDescription());
                this.setIcon(this.cache.get(end));
            }
            return this;
        }
    }
}

