/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.thread;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.Unstable;
import uk.org.retep.util.thread.DelayedRunnable;
import uk.org.retep.util.thread.DelayedRunnableThreadPoolExecutor;
import uk.org.retep.util.thread.GlobalThreadPool;
import uk.org.retep.util.thread.ShutdownManager;

@ThreadSafe
public abstract class ExecutorFactory {
    private static final Lock lock = new ReentrantLock();
    private static DelayedRunnableThreadPoolExecutor delayedThreadExecutor;
    private static ExecutorService globalThreadExecutor;
    private static final Map<String, Executor> singleThreadExecutors;
    private static final ThreadFactory singleThreadFactory;
    static final ThreadLocal<ThreadType> threadType;

    private ExecutorFactory() {
    }

    public static Executor getGlobalThreadExecutor() {
        return ExecutorFactory.getGlobalThreadExecutorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getGlobalThreadExecutorImpl() {
        lock.lock();
        try {
            if (globalThreadExecutor == null) {
                ThreadFactory threadFactory = GlobalThreadPool.createDaemonThreadFactory("GlobalThread Executor");
                ExecutorService service = Executors.newCachedThreadPool(threadFactory);
                globalThreadExecutor = new ExecutorWrapper(ThreadType.GLOBAL, service);
                ShutdownManager.addExecutorServiceShutdown(service);
            }
            ExecutorService executorService = globalThreadExecutor;
            return executorService;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DelayedRunnableThreadPoolExecutor getDelayedThreadExecutor() {
        lock.lock();
        try {
            if (delayedThreadExecutor == null) {
                delayedThreadExecutor = new DelayedRunnableThreadPoolExecutor();
                delayedThreadExecutor.prestartCoreThread();
            }
            DelayedRunnableThreadPoolExecutor delayedRunnableThreadPoolExecutor = delayedThreadExecutor;
            return delayedRunnableThreadPoolExecutor;
        }
        finally {
            lock.unlock();
        }
    }

    public static void schedule(DelayedRunnable task) {
        ExecutorFactory.getDelayedThreadExecutor().execute(task);
    }

    public static void unschedule(DelayedRunnable task) {
        ExecutorFactory.getDelayedThreadExecutor().remove(task);
    }

    public static void globalInvokeLater(Runnable task) {
        ExecutorFactory.getGlobalThreadExecutorImpl().execute(task);
    }

    public static <V> Future<V> globalSubmit(Callable<V> task) {
        return ExecutorFactory.getGlobalThreadExecutorImpl().submit(task);
    }

    public static Executor getSingleThreadExecutor() {
        return ExecutorFactory.getSingleThreadExecutor("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor getSingleThreadExecutor(String name) {
        lock.lock();
        try {
            Executor executor = singleThreadExecutors.get(name);
            if (executor == null) {
                ExecutorService service = Executors.newSingleThreadExecutor(singleThreadFactory);
                executor = new ExecutorWrapper(ThreadType.SINGLE, service);
                singleThreadExecutors.put(name, executor);
                ShutdownManager.addExecutorServiceShutdown(service);
            }
            Executor executor2 = executor;
            return executor2;
        }
        finally {
            lock.unlock();
        }
    }

    public static boolean isDelayedThread() {
        return ThreadType.DELAYED == threadType.get();
    }

    public static boolean isGlobalThread() {
        return ThreadType.GLOBAL == threadType.get();
    }

    @Unstable
    public static boolean isSingleThread() {
        return ThreadType.SINGLE == threadType.get();
    }

    static {
        singleThreadExecutors = new HashMap<String, Executor>();
        singleThreadFactory = GlobalThreadPool.createDaemonThreadFactory("SingleThread Executor");
        threadType = new ThreadLocal();
    }

    private static class ExecutorWrapper
    implements ExecutorService {
        private final ThreadType type;
        private final ExecutorService executor;

        public ExecutorWrapper(ThreadType type, ExecutorService executor) {
            this.type = type;
            this.executor = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(new RunnableWrapper(this.type, command));
        }

        @Override
        public void shutdown() {
            this.executor.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.executor.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        @Override
        public boolean awaitTermination(long arg0, TimeUnit arg1) throws InterruptedException {
            return this.executor.awaitTermination(arg0, arg1);
        }

        @Override
        public <T> Future<T> submit(Callable<T> arg0) {
            return this.executor.submit(arg0);
        }

        @Override
        public <T> Future<T> submit(Runnable arg0, T arg1) {
            return this.executor.submit(arg0, arg1);
        }

        @Override
        public Future<?> submit(Runnable arg0) {
            return this.executor.submit(arg0);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0) throws InterruptedException {
            return this.invokeAll(arg0);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException {
            return this.executor.invokeAll(arg0, arg1, arg2);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> arg0) throws InterruptedException, ExecutionException {
            return this.executor.invokeAny(arg0);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException, ExecutionException, TimeoutException {
            return this.invokeAny(arg0, arg1, arg2);
        }
    }

    private static class RunnableWrapper
    implements Runnable {
        private final ThreadType type;
        private final Runnable task;

        public RunnableWrapper(ThreadType type, Runnable task) {
            this.type = type;
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            threadType.set(this.type);
            try {
                this.task.run();
            }
            finally {
                threadType.remove();
            }
        }
    }

    static enum ThreadType {
        DELAYED,
        GLOBAL,
        SINGLE;

    }
}

