/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class JDBCUtils {
    private final DataSource dataSource;
    private static final ResultSetProcessor<Integer> INTEGER_PROCESSOR = new ResultSetProcessorAdaptor<Integer>(){

        @Override
        public Integer process(ResultSet rs) throws SQLException {
            return rs.getInt(1);
        }
    };
    private static final ResultSetProcessor<String> STRING_PROCESSOR = new ResultSetProcessorAdaptor<String>(){

        @Override
        public String process(ResultSet rs) throws SQLException {
            return rs.getString(1);
        }
    };
    private static final ResultSetProcessor<Boolean> BOOLEAN_PROCESSOR = new ResultSetProcessorAdaptor<Boolean>(){

        @Override
        public Boolean process(ResultSet rs) throws SQLException {
            return rs.getBoolean(1);
        }
    };

    public JDBCUtils(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Connection getConnection() throws SQLException {
        Connection con = this.dataSource.getConnection();
        con.setAutoCommit(false);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> List<T> processResults(ResultSetProcessor<T> processor, Statement st, boolean firstResult) throws SQLException {
        if (processor != null) {
            processor.init(st);
        }
        result = null;
        uc = 0;
        irs = firstResult;
        do {
            if (irs) {
                rs = st.getResultSet();
                try {
                    if (processor == null) ** GOTO lbl26
                    processor.startResultSet(rs);
                    while (rs.next()) {
                        rec = processor.process(rs);
                        if (rec == null) continue;
                        if (result == null) {
                            result = new ArrayList<T>();
                        }
                        result.add(rec);
                    }
                    processor.endResultSet(rs);
                }
                finally {
                    rs.close();
                }
            } else {
                uc = st.getUpdateCount();
            }
lbl26:
            // 3 sources

        } while ((irs = st.getMoreResults()) || uc != -1);
        return result;
    }

    public void setParameters(PreparedStatement ps, Object ... parameters) throws SQLException {
        if (parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                ps.setObject(i + 1, parameters[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql, Object ... parameters) throws SQLException {
        Connection con = this.dataSource.getConnection();
        try {
            this.execute(con, null, sql, parameters);
            con.commit();
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> execute(ResultSetProcessor<T> processor, String sql, Object ... parameters) throws SQLException {
        Connection con = this.dataSource.getConnection();
        try {
            List<T> result = this.execute(con, processor, sql, parameters);
            con.commit();
            List<T> list = result;
            return list;
        }
        finally {
            con.close();
        }
    }

    public void execute(Connection con, String sql, Object ... parameters) throws SQLException {
        this.execute(con, null, sql, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> execute(Connection con, ResultSetProcessor<T> processor, String sql, Object ... parameters) throws SQLException {
        PreparedStatement ps = con.prepareStatement(sql);
        try {
            this.setParameters(ps, parameters);
            List<T> list = this.processResults(processor, ps, ps.execute());
            return list;
        }
        finally {
            ps.close();
        }
    }

    public static ResultSetProcessor<Boolean> getBooleanResultSetProcessor() {
        return BOOLEAN_PROCESSOR;
    }

    public static ResultSetProcessor<Integer> getIntegerResultSetProcessor() {
        return INTEGER_PROCESSOR;
    }

    public static ResultSetProcessor<String> getStringResultSetProcessor() {
        return STRING_PROCESSOR;
    }

    public static abstract class ResultSetProcessorAdaptor<T>
    implements ResultSetProcessor<T> {
        @Override
        public void init(Statement st) throws SQLException {
        }

        @Override
        public void startResultSet(ResultSet rs) throws SQLException {
        }

        @Override
        public void endResultSet(ResultSet rs) throws SQLException {
        }
    }

    public static interface ResultSetProcessor<T> {
        public void init(Statement var1) throws SQLException;

        public void startResultSet(ResultSet var1) throws SQLException;

        public T process(ResultSet var1) throws SQLException;

        public void endResultSet(ResultSet var1) throws SQLException;
    }
}

