/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class CRC16
implements Externalizable {
    private static final int HSB = 32768;
    private static final int POW = 4129;
    private static final long serialVersionUID = -7341373802682308L;
    private int value = 0;

    public int getValue() {
        return this.value;
    }

    public void reset() {
        this.value = 0;
    }

    public void add(byte v) {
        int a = v;
        for (int c = 0; c <= 7; ++c) {
            int b = (a <<= 1) >>> 8 & 1;
            this.value = (this.value << 1) + b;
            if ((this.value & 0x8000) == 0) continue;
            this.value ^= 0x1021;
        }
        this.value &= 0xFFFF;
    }

    public void add(byte[] b) {
        this.add(b, 0, b.length);
    }

    public void add(byte[] b, int start, int length) {
        int p = start;
        for (int l = length; l > 0; --l) {
            this.add(b[p++]);
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CRC16)) {
            return false;
        }
        CRC16 b = (CRC16)CRC16.class.cast(obj);
        return this.value == b.value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.value);
    }
}

