/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.set;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.collections.set.LinkedHashOrderedSet;
import uk.org.retep.util.collections.set.LinkedOrderedSet;
import uk.org.retep.util.collections.set.OrderedSet;

@ThreadSafe
public class ConcurrentLinkedHashOrderedSet<K, V>
extends LinkedHashOrderedSet<K, V> {
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderedSet.Entry<K, V> findTail() {
        this.lock.readLock().lock();
        try {
            OrderedSet.Entry entry = super.findTail();
            return entry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.lock.readLock().lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        this.lock.readLock().lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderedSet.Entry<K, V> findEntry(K key) {
        this.lock.readLock().lock();
        try {
            OrderedSet.Entry entry = super.findEntry(key);
            return entry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(K key, V value) {
        this.lock.writeLock().lock();
        try {
            super.append(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBefore(K before, K key, V value) {
        this.lock.writeLock().lock();
        try {
            super.addBefore(before, key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAfter(K after, K key, V value) {
        this.lock.writeLock().lock();
        try {
            super.addAfter(after, key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertEntry(OrderedSet.Entry<K, V> prev, OrderedSet.Entry<K, V> next, OrderedSet.Entry<K, V> entry) {
        this.lock.writeLock().lock();
        try {
            super.insertEntry(prev, next, entry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(OrderedSet.Entry<K, V> entry) {
        if (entry == null || !(entry instanceof LinkedOrderedSet.OSEntry) || !this.equals(entry.getSet())) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            super.removeEntry(entry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            super.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reorder() {
        this.lock.writeLock().lock();
        try {
            super.reorder();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

