/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class Service {
    private Service() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Collection<String> providerClassNames(String className, ClassLoader classLoader) {
        String providerFile = "META-INF/services/" + className;
        Service instance = new Service();
        instance.toString();
        ArrayList<String> providers = new ArrayList<String>();
        try {
            Enumeration<URL> providerFiles = classLoader.getResources(providerFile);
            while (providerFiles.hasMoreElements()) {
                try {
                    URL url = providerFiles.nextElement();
                    InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
                    try {
                        Service.loadClassNames(reader, providers);
                    }
                    finally {
                        ((Reader)reader).close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return providers;
    }

    public static synchronized <T> Collection<Class<T>> providerClasses(Class<T> cls) {
        Service.providerClasses(cls, cls.getClassLoader());
        return Service.providerClasses(cls, cls.getClassLoader());
    }

    public static synchronized <T> Collection<Class<T>> providerClasses(Class<T> cls, ClassLoader classLoader) {
        Collection<String> providerNames = Service.providerClassNames(cls.getName(), classLoader);
        ArrayList<Class<T>> providers = new ArrayList<Class<T>>(providerNames.size());
        for (String providerName : providerNames) {
            try {
                providers.add(classLoader.loadClass(providerName));
            }
            catch (Throwable ex) {}
        }
        return providers;
    }

    private static void loadClassNames(Reader input, List<String> providerNames) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        String line = reader.readLine();
        while (line != null) {
            int idx = line.indexOf(35);
            if (idx != -1) {
                line = line.substring(0, idx);
            }
            if ((line = line.trim()).length() > 0) {
                providerNames.add(line);
            }
            line = reader.readLine();
        }
    }
}

