/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import uk.org.retep.util.io.tar.InvalidHeaderException;
import uk.org.retep.util.io.tar.TarArchive;
import uk.org.retep.util.io.tar.TarEntry;
import uk.org.retep.util.io.tar.TarProgressDisplay;

public class Tar
implements TarProgressDisplay {
    private boolean debug = false;
    private boolean verbose = false;
    private boolean compressed = false;
    private boolean listingArchive = false;
    private boolean writingArchive = true;
    private boolean unixArchiveFormat = false;
    private boolean keepOldFiles = false;
    private boolean asciiTranslate = false;
    private boolean mimeFileLoaded;
    private String archiveName = null;
    private int blockSize = 10240;
    private int userId;
    private String userName;
    private int groupId;
    private String groupName;

    public static void main(String ... argv) {
        Tar app = new Tar();
        app.instanceMain(argv);
    }

    public Tar() {
        String sysUserName = System.getProperty("user.name");
        this.userId = 0;
        this.userName = sysUserName == null ? "" : sysUserName;
        this.groupId = 0;
        this.groupName = "";
    }

    public void instanceMain(String[] argv) {
        TarArchive archive = null;
        int argIdx = this.processArguments(argv);
        if (this.writingArchive) {
            OutputStream outStream = System.out;
            if (this.archiveName != null && !this.archiveName.equals("-")) {
                try {
                    outStream = new FileOutputStream(this.archiveName);
                }
                catch (IOException ex) {
                    outStream = null;
                    ex.printStackTrace(System.err);
                }
            }
            if (outStream != null) {
                if (this.compressed) {
                    try {
                        outStream = new GZIPOutputStream(outStream);
                    }
                    catch (IOException ex) {
                        outStream = null;
                        ex.printStackTrace(System.err);
                    }
                }
                archive = new TarArchive(outStream, this.blockSize);
            }
        } else {
            InputStream inStream = System.in;
            if (this.archiveName != null && !this.archiveName.equals("-")) {
                try {
                    inStream = new FileInputStream(this.archiveName);
                }
                catch (IOException ex) {
                    inStream = null;
                    ex.printStackTrace(System.err);
                }
            }
            if (inStream != null) {
                if (this.compressed) {
                    try {
                        inStream = new GZIPInputStream(inStream);
                    }
                    catch (IOException ex) {
                        inStream = null;
                        ex.printStackTrace(System.err);
                    }
                }
                archive = new TarArchive(inStream, this.blockSize);
            }
        }
        if (archive != null) {
            archive.setDebug(this.debug);
            archive.setVerbose(this.verbose);
            archive.setTarProgressDisplay(this);
            archive.setKeepOldFiles(this.keepOldFiles);
            archive.setAsciiTranslation(this.asciiTranslate);
            archive.setUserInfo(this.userId, this.userName, this.groupId, this.groupName);
        }
        if (archive == null) {
            System.err.println("no processing due to errors");
        } else if (this.writingArchive) {
            while (argIdx < argv.length) {
                try {
                    File f = new File(argv[argIdx]);
                    TarEntry entry = new TarEntry(f);
                    if (this.unixArchiveFormat) {
                        entry.setUnixTarFormat();
                    } else {
                        entry.setUSTarFormat();
                    }
                    archive.writeEntry(entry, true);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                ++argIdx;
            }
        } else if (this.listingArchive) {
            try {
                archive.listContents();
            }
            catch (InvalidHeaderException ex) {
                ex.printStackTrace(System.err);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        } else {
            String userDir = System.getProperty("user.dir", null);
            File destDir = new File(userDir);
            if (!destDir.exists() && !destDir.mkdirs()) {
                destDir = null;
                Throwable ex = new Throwable("ERROR, mkdirs() on '" + destDir.getPath() + "' returned false.");
                ex.printStackTrace(System.err);
            }
            if (destDir != null) {
                try {
                    archive.extractContents(destDir);
                }
                catch (InvalidHeaderException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        if (archive != null) {
            try {
                archive.closeArchive();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private int processArguments(String[] args) {
        String arg;
        int idx;
        boolean gotOP = false;
        for (idx = 0; idx < args.length && (arg = args[idx]).startsWith("-"); ++idx) {
            if (arg.startsWith("--")) {
                if (arg.equals("--usage")) {
                    this.usage();
                    System.exit(1);
                    continue;
                }
                if (arg.equals("--version")) {
                    this.version();
                    System.exit(1);
                    continue;
                }
                if (arg.equals("--trans")) {
                    this.asciiTranslate = true;
                    String jafClassName = "javax.activation.FileTypeMap";
                    try {
                        Class<?> jafClass = Class.forName(jafClassName);
                        if (this.mimeFileLoaded) continue;
                        URL mimeURL = Tar.class.getResource("/uk/org/retep/util/io/tar/asciimime.txt");
                        URLConnection mimeConn = mimeURL.openConnection();
                        InputStream in = mimeConn.getInputStream();
                        FileTypeMap.setDefaultFileTypeMap((FileTypeMap)new MimetypesFileTypeMap(in));
                    }
                    catch (ClassNotFoundException ex) {
                        System.err.println("Could not load the class named '" + jafClassName + "'.\n" + "The Java Activation package must " + "be installed to use ascii translation.");
                        System.exit(1);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                        System.exit(1);
                    }
                    continue;
                }
                if (arg.equals("--mime")) {
                    this.mimeFileLoaded = true;
                    String jafClassName = "javax.activation.FileTypeMap";
                    File mimeFile = new File(args[++idx + 1]);
                    try {
                        Class<?> jafClass = Class.forName(jafClassName);
                        FileTypeMap.setDefaultFileTypeMap((FileTypeMap)new MimetypesFileTypeMap((InputStream)new FileInputStream(mimeFile)));
                    }
                    catch (ClassNotFoundException ex) {
                        System.err.println("Could not load the class named '" + jafClassName + "'.\n" + "The Java Activation package must " + "be installed to use ascii translation.");
                        System.exit(1);
                    }
                    catch (FileNotFoundException ex) {
                        System.err.println("Could not open the mimetypes file '" + mimeFile.getPath() + "', " + ex.getMessage());
                    }
                    continue;
                }
                System.err.println("unknown option: " + arg);
                this.usage();
                System.exit(1);
                continue;
            }
            for (int cIdx = 1; cIdx < arg.length(); ++cIdx) {
                char ch = arg.charAt(cIdx);
                if (ch == '?') {
                    this.usage();
                    System.exit(1);
                    continue;
                }
                if (ch == 'f') {
                    this.archiveName = args[++idx];
                    continue;
                }
                if (ch == 'z') {
                    this.compressed = true;
                    continue;
                }
                if (ch == 'c') {
                    gotOP = true;
                    this.writingArchive = true;
                    this.listingArchive = false;
                    continue;
                }
                if (ch == 'x') {
                    gotOP = true;
                    this.writingArchive = false;
                    this.listingArchive = false;
                    continue;
                }
                if (ch == 't') {
                    gotOP = true;
                    this.writingArchive = false;
                    this.listingArchive = true;
                    continue;
                }
                if (ch == 'k') {
                    this.keepOldFiles = true;
                    continue;
                }
                if (ch == 'o') {
                    this.unixArchiveFormat = true;
                    continue;
                }
                if (ch == 'b') {
                    try {
                        int blks = Integer.parseInt(args[++idx]);
                        this.blockSize = blks * 512;
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace(System.err);
                    }
                    continue;
                }
                if (ch == 'u') {
                    this.userName = args[++idx];
                    continue;
                }
                if (ch == 'U') {
                    String idStr = args[++idx];
                    try {
                        this.userId = Integer.parseInt(idStr);
                    }
                    catch (NumberFormatException ex) {
                        this.userId = 0;
                        ex.printStackTrace(System.err);
                    }
                    continue;
                }
                if (ch == 'g') {
                    this.groupName = args[++idx];
                    continue;
                }
                if (ch == 'G') {
                    String idStr = args[++idx];
                    try {
                        this.groupId = Integer.parseInt(idStr);
                    }
                    catch (NumberFormatException ex) {
                        this.groupId = 0;
                        ex.printStackTrace(System.err);
                    }
                    continue;
                }
                if (ch == 'v') {
                    this.verbose = true;
                    continue;
                }
                if (ch == 'D') {
                    this.debug = true;
                    continue;
                }
                System.err.println("unknown option: " + ch);
                this.usage();
                System.exit(1);
            }
        }
        if (!gotOP) {
            System.err.println("you must specify an operation option (c, x, or t)");
            this.usage();
            System.exit(1);
        }
        return idx;
    }

    @Override
    public void showTarProgressMessage(String msg) {
        System.out.println(msg);
    }

    private void version() {
        System.err.println("Release 2.4 - $Revision: 1.10 $ $Name:  $");
    }

    private void usage() {
        System.err.println("usage: com.ice.tar.tar has three basic modes:");
        System.err.println("  com.ice.tar -c [options] archive files...");
        System.err.println("    Create new archive containing files.");
        System.err.println("  com.ice.tar -t [options] archive");
        System.err.println("    List contents of tar archive");
        System.err.println("  com.ice.tar -x [options] archive");
        System.err.println("    Extract contents of tar archive.");
        System.err.println("");
        System.err.println("options:");
        System.err.println("   -f file, use 'file' as the tar archive");
        System.err.println("   -v, verbose mode");
        System.err.println("   -z, use GZIP compression");
        System.err.println("   -D, debug archive and buffer operation");
        System.err.println("   -b blks, set blocking size to (blks * 512) bytes");
        System.err.println("   -o, write a V7 format archive rather than ANSI");
        System.err.println("   -u name, set user name to 'name'");
        System.err.println("   -U id, set user id to 'id'");
        System.err.println("   -g name, set group name to 'name'");
        System.err.println("   -G id, set group id to 'id'");
        System.err.println("   -?, print usage information");
        System.err.println("   --trans, translate 'text/*' files");
        System.err.println("   --mime file, use this mime types file and translate");
        System.err.println("   --usage, print usage information");
        System.err.println("   --version, print version information");
        System.err.println("");
        System.err.println("The translation options will translate from local line");
        System.err.println("endings to UNIX line endings of '\\n' when writing tar");
        System.err.println("archives, and from UNIX line endings into local line endings");
        System.err.println("when extracting archives.");
        System.err.println("");
        System.err.println("Written by Tim Endres");
        System.err.println("");
        System.err.println("This software has been placed into the public domain.");
        System.err.println("");
        this.version();
        System.exit(1);
    }
}

