/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.concurrent.ConcurrencySupport;
import uk.org.retep.util.http.RequestUtils;

@ThreadSafe
public abstract class AbstractHttpHandler
extends ConcurrencySupport
implements HttpHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        try {
            this.processExchange(exchange);
        }
        catch (IOException ioe) {
            this.getLog().error((Object)"IOException", ioe);
            throw ioe;
        }
        catch (RuntimeException re) {
            this.getLog().error((Object)"RuntimeException", re);
            throw re;
        }
        catch (Exception t) {
            this.getLog().error("Uncaught Exception %s", t, t.getClass());
        }
        finally {
            exchange.close();
        }
    }

    public void processExchange(HttpExchange exchange) throws IOException {
        String method = exchange.getRequestMethod();
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info("%s: %s %s", exchange.getHttpContext().getPath(), method, exchange.getRequestURI());
        }
        if ("get".equalsIgnoreCase(method)) {
            this.processGet(exchange);
        } else if ("post".equalsIgnoreCase(method)) {
            this.processPost(exchange);
        } else {
            this.processOther(exchange);
        }
    }

    public void processGet(HttpExchange exchange) throws IOException {
        RequestUtils.sendResponse(exchange, 500, "GET not implemented", new Object[0]);
    }

    public void processPost(HttpExchange exchange) throws IOException {
        RequestUtils.sendResponse(exchange, 500, "POST not implemented", new Object[0]);
    }

    public void processOther(HttpExchange exchange) throws IOException {
        RequestUtils.sendResponse(exchange, 500, exchange.getRequestMethod() + " not implemented", new Object[0]);
    }
}

