/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.logging;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.jcip.annotations.ThreadSafe;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import uk.org.retep.annotations.Contract;
import uk.org.retep.annotations.DispatchThread;
import uk.org.retep.annotations.InvocationType;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;

@ThreadSafe
public class ListLogAppender
extends AppenderSkeleton
implements ListModel {
    private static final int MAX_ROWS = 500;
    private static Map<String, ListLogAppender> appenders = new ConcurrentHashMap<String, ListLogAppender>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private List<String> list = new ArrayList<String>();
    private Set<ListDataListener> listeners;
    private ListDataListener[] listenerCache;
    private int maxRows = 500;

    public static ListLogAppender getCollection(String name) {
        return appenders.get(name);
    }

    @Contract(value={ReadLock.class})
    private Lock readLock() {
        return this.lock.readLock();
    }

    @Contract(value={WriteLock.class})
    private Lock writeLock() {
        return this.lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    public int getMaxRows() {
        this.readLock().lock();
        try {
            int n = this.maxRows;
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void setMaxRows(int maxRows) {
        this.writeLock().lock();
        try {
            this.maxRows = Math.min(100, maxRows);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void setName(String name) {
        this.writeLock().lock();
        try {
            super.setName(name);
            appenders.put(name, this);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    protected synchronized void append(LoggingEvent event) {
        this.append(this.layout.format(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    private void append(String s) {
        this.writeLock().lock();
        try {
            int first = this.list.size() - 1;
            int l = s.length();
            int p = 0;
            int e = s.indexOf(10);
            while (e > p && p < l) {
                this.list.add(s.substring(p, e));
                p = e + 1;
                e = s.indexOf(10, p);
                if (first <= 0) continue;
                --first;
            }
            if (p < l) {
                this.list.add(s.substring(p));
            }
            if (this.list.size() > this.maxRows) {
                int d = this.list.size() - this.maxRows;
                while (this.list.size() > this.maxRows) {
                    this.list.remove(0);
                }
                this.fireRemove(d);
            }
            this.fireAdd(first, this.list.size());
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private void fireAdd(int s, int e) {
        this.fire(new ListDataEvent(this, 1, s, e));
    }

    private void fireRemove(int i) {
        this.fire(new ListDataEvent(this, 2, 0, i));
    }

    @DispatchThread(invocationType=InvocationType.INVOKE_LATER)
    private void fire(ListDataEvent e) {
        EventQueue.invokeLater(new 0r(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void close() {
        this.writeLock().lock();
        try {
            this.list.clear();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public int getSize() {
        this.readLock().lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    public Object getElementAt(int index) {
        this.readLock().lock();
        try {
            String string = this.list.get(index);
            return string;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void addListDataListener(ListDataListener l) {
        this.writeLock().lock();
        try {
            if (this.listeners == null) {
                this.listeners = new HashSet<ListDataListener>();
            }
            this.listeners.add(l);
            this.updateCache();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void removeListDataListener(ListDataListener l) {
        this.writeLock().lock();
        try {
            this.listeners.remove(l);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private void updateCache() {
        this.listenerCache = this.listeners.toArray(new ListDataListener[this.listeners.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    private ListDataListener[] getListeners() {
        this.readLock().lock();
        try {
            ListDataListener[] listDataListenerArray = this.listenerCache;
            return listDataListenerArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    private void fire$0(ListDataEvent e) {
        try {
            for (ListDataListener l : this.getListeners()) {
                l.intervalAdded(e);
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    class 0r
    implements Runnable {
        private final ListDataEvent e;

        0r(ListDataEvent x1) {
            this.e = x1;
        }

        @Override
        public void run() {
            ListLogAppender.this.fire$0(this.e);
        }
    }
}

