/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.pool;

import java.util.concurrent.Executor;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.pool.IdentityPoolEntryFactory;

@ThreadSafe
public abstract class ExecutorRefreshIdentityPoolFactory<I, T>
implements IdentityPoolEntryFactory<I, T> {
    private final Executor executor;

    public ExecutorRefreshIdentityPoolFactory(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void initialise(IdentityPoolEntryFactory.IdentityPoolInitialiser<I, T> initialiser) {
    }

    @Override
    public final void refresh(IdentityPoolEntryFactory.IdentityPoolEntry<I, T> entry) throws InterruptedException {
        this.executor.execute(new Task(entry));
        entry.awaitForRefresh();
    }

    @Override
    public void removed(I identity, T item) {
    }

    protected abstract void refreshImpl(IdentityPoolEntryFactory.IdentityPoolEntry<I, T> var1);

    private class Task
    implements Runnable {
        private final IdentityPoolEntryFactory.IdentityPoolEntry<I, T> entry;

        public Task(IdentityPoolEntryFactory.IdentityPoolEntry<I, T> entry) {
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ExecutorRefreshIdentityPoolFactory.this.refreshImpl(this.entry);
            }
            finally {
                this.entry.refreshed();
            }
        }
    }
}

