/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.queue;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.Lock;
import uk.org.retep.util.thread.DelayedRunnable;

@ThreadSafe
public class DelayedBlockingQueue
extends AbstractCollection<Runnable>
implements BlockingQueue<Runnable> {
    private final ReentrantLock lock = new ReentrantLock();
    private final DelayQueue<DelayedRunnable> dq;

    private java.util.concurrent.locks.Lock lock() {
        return this.lock;
    }

    public DelayedBlockingQueue() {
        this(new DelayQueue());
    }

    public DelayedBlockingQueue(DelayQueue<? extends DelayedRunnable> dq) {
        this.dq = dq;
    }

    @Override
    public Runnable poll() {
        return (Runnable)this.dq.poll();
    }

    @Override
    public Runnable peek() {
        return (Runnable)this.dq.peek();
    }

    @Override
    public Runnable take() throws InterruptedException {
        return (Runnable)this.dq.take();
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (Runnable)this.dq.poll(timeout, unit);
    }

    @Override
    public boolean add(Runnable x) {
        assert (this.offer(x));
        return true;
    }

    @Override
    @Lock
    public boolean offer(Runnable x) {
        if (!(x instanceof DelayedRunnable)) {
            throw new ClassCastException("Runnable does not implement DelayedRunnable interface");
        }
        if (this.dq.contains(x)) {
            this.dq.remove(x);
        }
        return this.dq.offer((DelayedRunnable)((Delayed)DelayedRunnable.class.cast(x)));
    }

    @Override
    public void put(Runnable x) {
        this.offer(x);
    }

    @Override
    public boolean offer(Runnable x, long timeout, TimeUnit unit) {
        return this.offer(x);
    }

    @Override
    @Lock
    public Runnable remove() {
        return (Runnable)this.dq.remove();
    }

    @Override
    @Lock
    public Runnable element() {
        return (Runnable)this.dq.element();
    }

    @Override
    @Lock
    public void clear() {
        this.dq.clear();
    }

    @Override
    @Lock
    public int drainTo(Collection<? super Runnable> c) {
        return this.dq.drainTo(c);
    }

    @Override
    @Lock
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        return this.dq.drainTo(c, maxElements);
    }

    @Override
    public int remainingCapacity() {
        return this.dq.remainingCapacity();
    }

    @Override
    @Lock
    public boolean remove(Object x) {
        return this.dq.remove(x);
    }

    @Override
    @Lock
    public boolean contains(Object x) {
        return this.dq.contains(x);
    }

    @Override
    @Lock
    public int size() {
        return this.dq.size();
    }

    @Override
    @Lock
    public boolean isEmpty() {
        return this.dq.isEmpty();
    }

    @Override
    @Lock
    public Object[] toArray() {
        return this.dq.toArray();
    }

    @Override
    @Lock
    public <T> T[] toArray(T[] array) {
        return this.dq.toArray(array);
    }

    @Override
    @Lock
    public Iterator<Runnable> iterator() {
        return new Iterator<Runnable>(){
            private Iterator<DelayedRunnable> it;
            {
                this.it = DelayedBlockingQueue.this.dq.iterator();
            }

            @Override
            @Lock
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            @Lock
            public Runnable next() {
                return this.it.next();
            }

            @Override
            @Lock
            public void remove() {
                this.it.remove();
            }
        };
    }
}

