/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.queue;

import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.collections.queue.ConcurrentQueue;

@ThreadSafe
public class ConcurrentDeque<E>
extends ConcurrentQueue<E>
implements Deque<E> {
    private final Deque<E> deque;

    public ConcurrentDeque(List<E> list) {
        super(list);
        if (!(list instanceof Deque)) {
            throw new ClassCastException("List must also implement Deque");
        }
        this.deque = (Deque)((Object)list);
    }

    public ConcurrentDeque(Deque<E> deque) {
        super(deque);
        this.deque = deque;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFirst(E e) {
        this.writeLock().lock();
        try {
            this.deque.addFirst(e);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLast(E e) {
        this.writeLock().lock();
        try {
            this.deque.addLast(e);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.readLock().lock();
        try {
            boolean bl = this.deque.contains(o);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> descendingIterator() {
        this.readLock().lock();
        try {
            Iterator<E> iterator = this.deque.descendingIterator();
            return iterator;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getFirst() {
        this.readLock().lock();
        try {
            E e = this.deque.getFirst();
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getLast() {
        this.readLock().lock();
        try {
            E e = this.deque.getLast();
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        this.readLock().lock();
        try {
            Iterator<E> iterator = this.deque.iterator();
            return iterator;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e) {
        this.writeLock().lock();
        try {
            boolean bl = this.deque.offerFirst(e);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e) {
        this.writeLock().lock();
        try {
            boolean bl = this.deque.offerLast(e);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekFirst() {
        this.readLock().lock();
        try {
            E e = this.deque.peekFirst();
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekLast() {
        this.readLock().lock();
        try {
            E e = this.deque.peekLast();
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst() {
        this.writeLock().lock();
        try {
            E e = this.deque.pollFirst();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast() {
        this.writeLock().lock();
        try {
            E e = this.deque.pollLast();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pop() {
        this.writeLock().lock();
        try {
            E e = this.deque.pop();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(E e) {
        this.writeLock().lock();
        try {
            this.deque.push(e);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.writeLock().lock();
        try {
            boolean bl = this.deque.remove(o);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E removeFirst() {
        this.writeLock().lock();
        try {
            E e = this.deque.removeFirst();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFirstOccurrence(Object o) {
        this.writeLock().lock();
        try {
            boolean bl = this.deque.removeFirstOccurrence(o);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E removeLast() {
        this.writeLock().lock();
        try {
            E e = this.deque.removeLast();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object o) {
        this.writeLock().lock();
        try {
            boolean bl = this.deque.removeLastOccurrence(o);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.readLock().lock();
        try {
            int n = this.deque.size();
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }
}

