/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.annotation.validator;

import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import uk.org.retep.util.javac.JavacUtils;
import uk.org.retep.util.string.StringUtils;

public class AbstractCodeAnalyser
extends TreePathScanner<Object, Trees> {
    private ResourceBundle bundle;
    protected final JavacUtils javacUtils;
    private Set<Message> messages = new LinkedHashSet<Message>();
    private MetaData metadata;

    public AbstractCodeAnalyser(JavacUtils javacUtils) {
        this.javacUtils = javacUtils;
        this.bundle = ResourceBundle.getBundle("uk/org/retep/util/annotation/validator/messages");
    }

    protected final void report() {
        for (Message message : this.messages) {
            message.report();
        }
        this.messages.clear();
    }

    protected final void push(MetaData metadata) {
        if (this.metadata != null) {
            metadata.setParent(this.metadata);
        }
        this.metadata = metadata;
    }

    protected final void pop() {
        this.metadata = this.metadata != null ? this.metadata.getParent() : null;
    }

    protected final <T extends MetaData> T getMetaData() {
        return (T)this.metadata;
    }

    protected final void warn(Element element, String message, Object ... args) {
        this.warn(element, null, message, args);
    }

    protected final void mandatoryWarning(Element element, String message, Object ... args) {
        this.mandatoryWarning(element, null, message, args);
    }

    protected final void error(Element element, String message, Object ... args) {
        this.error(element, null, message, args);
    }

    protected final void note(Element element, String message, Object ... args) {
        this.note(element, null, message, args);
    }

    protected final void other(Element element, String message, Object ... args) {
        this.other(element, null, message, args);
    }

    protected final void warn(Element element, Class<?> clazz, String message, Object ... args) {
        this.printMessage(element, Diagnostic.Kind.WARNING, clazz, null, null, message, args);
    }

    protected final void mandatoryWarning(Element element, Class<?> clazz, String message, Object ... args) {
        this.printMessage(element, Diagnostic.Kind.MANDATORY_WARNING, clazz, null, null, message, args);
    }

    protected final void error(Element element, Class<?> clazz, String message, Object ... args) {
        this.printMessage(element, Diagnostic.Kind.ERROR, clazz, null, null, message, args);
    }

    protected final void note(Element element, Class<?> clazz, String message, Object ... args) {
        this.printMessage(element, Diagnostic.Kind.NOTE, clazz, null, null, message, args);
    }

    protected final void other(Element element, Class<?> clazz, String message, Object ... args) {
        this.printMessage(element, Diagnostic.Kind.OTHER, clazz, null, null, message, args);
    }

    protected final void printMessage(Element element, Diagnostic.Kind kind, Class<?> clazz, AnnotationMirror annotationMirror, AnnotationValue annotationValue, String message, Object ... args) {
        this.messages.add(new Message(element, kind, annotationMirror, annotationValue, clazz, message, args));
    }

    protected final Element getCurrentElement() {
        return this.javacUtils.trees.getElement(this.getCurrentPath());
    }

    private class Message {
        private final Element element;
        private final Diagnostic.Kind kind;
        private final AnnotationMirror annotationMirror;
        private final AnnotationValue annotationValue;
        private final String message;

        public Message(Element element, Diagnostic.Kind kind, AnnotationMirror annotationMirror, AnnotationValue annotationValue, Class<?> clazz, String message, Object ... args) {
            this.element = element;
            this.kind = kind;
            this.annotationMirror = annotationMirror;
            this.annotationValue = annotationValue;
            String msg = AbstractCodeAnalyser.this.bundle.getString(message);
            this.message = clazz == null ? StringUtils.format(msg, args) : StringUtils.format(clazz.getSimpleName() + ": " + msg, args);
        }

        public int hashCode() {
            return (this.element == null ? 1 : ((Object)this.element).hashCode()) ^ this.message.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Message) {
                Message b = (Message)Message.class.cast(obj);
                if (this.message.equals(b.message)) {
                    if (this.element == null) {
                        return b.element == null;
                    }
                    return ((Object)this.element).equals(b.element);
                }
            }
            return false;
        }

        public void report() {
            if (this.element == null) {
                AbstractCodeAnalyser.this.javacUtils.messager.printMessage(this.kind, this.message);
            } else if (this.annotationMirror == null) {
                AbstractCodeAnalyser.this.javacUtils.messager.printMessage(this.kind, this.message, this.element);
            } else if (this.annotationValue == null) {
                AbstractCodeAnalyser.this.javacUtils.messager.printMessage(this.kind, this.message, this.element);
            } else if (this.annotationValue == null) {
                AbstractCodeAnalyser.this.javacUtils.messager.printMessage(this.kind, this.message, this.element, this.annotationMirror);
            } else {
                AbstractCodeAnalyser.this.javacUtils.messager.printMessage(this.kind, this.message, this.element, this.annotationMirror, this.annotationValue);
            }
        }
    }

    public static class MetaData {
        private MetaData parent;

        void setParent(MetaData parent) {
            this.parent = parent;
        }

        MetaData getParent() {
            return this.parent;
        }
    }
}

