/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.thread;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class GlobalThreadPool {
    private static ThreadGroup threadGroup = new ThreadGroup("retep.org.uk");
    private static Map<String, ThreadGroup> threadGroupMap = new ConcurrentHashMap<String, ThreadGroup>();
    private static Map<String, AtomicInteger> threadIdMap = new ConcurrentHashMap<String, AtomicInteger>();
    private static ClassLoader contextClassLoader;

    private GlobalThreadPool() {
    }

    public static ThreadGroup getRootThreadGroup() {
        return threadGroup;
    }

    public static ClassLoader getContextClassLoader() {
        return contextClassLoader;
    }

    public static void setContextClassLoader(ClassLoader contextClassLoader) {
        GlobalThreadPool.contextClassLoader = contextClassLoader;
    }

    public static synchronized ThreadGroup getThreadGroup(String name) {
        ThreadGroup tg = threadGroupMap.get(name);
        if (tg == null) {
            tg = new ThreadGroup(GlobalThreadPool.getRootThreadGroup(), name);
            threadGroupMap.put(name, tg);
            threadIdMap.put(name, new AtomicInteger());
        }
        return tg;
    }

    public static Thread createThread(String name, Runnable runnable) {
        ThreadGroup tg = GlobalThreadPool.getThreadGroup(name);
        int threadId = threadIdMap.get(name).incrementAndGet();
        String threadName = name + "-" + threadId;
        Thread thread = new Thread(tg, runnable, threadName);
        if (contextClassLoader != null) {
            thread.setContextClassLoader(contextClassLoader);
        }
        return thread;
    }

    public static Thread createDaemonThread(String name, Runnable runnable) {
        Thread thread = GlobalThreadPool.createThread(name, runnable);
        thread.setDaemon(true);
        return thread;
    }

    public static ThreadFactory createThreadFactory(final String name) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return GlobalThreadPool.createThread(name, runnable);
            }
        };
    }

    public static ThreadFactory createDaemonThreadFactory(final String name) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return GlobalThreadPool.createDaemonThread(name, runnable);
            }
        };
    }
}

