/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.thread;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public abstract class DelayedAdaptor
implements Delayed {
    private long triggerTime;

    public DelayedAdaptor() {
        this(0L);
    }

    public DelayedAdaptor(long delay, TimeUnit delayUnit) {
        this.setDelay(delay, delayUnit);
    }

    public DelayedAdaptor(long delay) {
        this.setDelay(delay);
    }

    public final void setTriggerTime(long triggerTime, TimeUnit triggerUnit) {
        this.setTriggerTime(TimeUnit.MILLISECONDS.convert(triggerTime, triggerUnit));
    }

    public final void setTriggerTime(long triggerTime) {
        this.triggerTime = triggerTime;
    }

    public final long getTriggerTime() {
        return this.triggerTime;
    }

    public final void setDelay(long delay, TimeUnit delayUnit) {
        this.setDelay(TimeUnit.MILLISECONDS.convert(delay, delayUnit));
    }

    public final void setDelay(long delay) {
        this.setTriggerTime(this.currentTimeMillis() + delay);
    }

    public final long getDelay() {
        return this.getDelay(TimeUnit.MILLISECONDS);
    }

    @Override
    public final int compareTo(Delayed d) {
        return (int)(this.getDelay(TimeUnit.MILLISECONDS) - d.getDelay(TimeUnit.MILLISECONDS));
    }

    @Override
    public final long getDelay(TimeUnit unit) {
        return unit.convert(this.triggerTime - this.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

