/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.string;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class StringUtils {
    public static final String DELIMITERS = " \t\n\r\f";
    public static final String EMPTY = "";
    public static final char NL = '\n';
    public static final String NLS = "\n";
    public static final char BACKSLASH = '\\';
    public static final String COMMENT = "#";
    public static final String keyValueSeparators = "=: \t\r\n\f";
    public static final String strictKeyValueSeparators = "=:";
    public static final String specialSaveChars = "=: \t\r\n\f#!";
    public static final String whiteSpaceChars = " \t\r\n\f";
    public static final String hexLow = "0123456789abcdef";
    public static final String hexHigh = "0123456789ABCDEF";
    public static final String UTF8_ENCODING = "UTF-8";
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] digits10 = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] digits1 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final String[][] NORMALISE_REGEX = new String[][]{{"\n|\r", " "}, {"\\.[ ]+", ". "}, {"[ ]+", " "}, {"^[ ]+|[ ]+$", ""}};
    private static final String[][] NORMALISE_REGEX2 = new String[][]{{"[ ]+\n[ ]+|[ ]+\n|\n[ ]+", "\n"}, {"[ ]+\r[ ]+|[ ]+\r|\r[ ]+", "\r"}, {"[ ]+\r\n[ ]+[ ]+\r\n|\r\n[ ]+", "\r\n"}, {"\\.[ ]+", ". "}, {"[ ]+", " "}, {"^[ ]+|[ ]+$", ""}};
    private static final String INDENT = "                                                                                ";

    private StringUtils() {
    }

    public static String padString(char c, int l) {
        return StringUtils.padString(EMPTY, c, l);
    }

    public static String padString(String s, char c, int l) {
        char[] t = new char[l];
        int p = 0;
        if (s != null) {
            p = Math.min(s.length(), l);
            s.getChars(0, p, t, 0);
        }
        if (p < l) {
            Arrays.fill(t, p, l, c);
        }
        return String.valueOf(t);
    }

    public static boolean isStringEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isStringNotEmpty(String s) {
        return !StringUtils.isStringEmpty(s);
    }

    public static String lowercase(String s) {
        if (StringUtils.isStringEmpty(s)) {
            return s;
        }
        if (s.length() > 1) {
            return s.substring(0, 1).toLowerCase() + s.substring(1);
        }
        return s.toLowerCase();
    }

    public static String capitalise(String s) {
        if (StringUtils.isStringEmpty(s)) {
            return s;
        }
        if (s.length() < 2) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String capitaliseEnum(String s) {
        return StringUtils.capitalise(s.replace('_', ' '));
    }

    public static String getEnumValue(Object s) {
        return String.valueOf(s).replace(' ', '_').toUpperCase();
    }

    public static List<String> splitString(String s, char delimiter) {
        return StringUtils.splitString(s.toCharArray(), delimiter);
    }

    public static List<String> splitString(String s, int start, int end, char delimiter) {
        return StringUtils.splitString(s.toCharArray(), start, end, delimiter);
    }

    public static List<String> splitString(char[] s, char delimiter) {
        return StringUtils.splitString(s, 0, s.length, delimiter);
    }

    public static List<String> splitString(char[] s, int start, int end, char delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int p = start;
        while (p < end) {
            char c;
            if ((c = s[p++]) == '\\' && p < end) {
                sb.append(s[p++]);
                continue;
            }
            if (c == delimiter) {
                list.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0 || list.isEmpty()) {
            list.add(sb.toString());
        }
        return list;
    }

    public static List<String> splitString(String s) {
        return StringUtils.splitString(s, DELIMITERS);
    }

    public static List<String> splitString(String s, String delimiters) {
        if (s == null) {
            return Collections.emptyList();
        }
        return StringUtils.splitString(s.toCharArray(), delimiters.toCharArray());
    }

    public static List<String> splitString(String s, int start, int end) {
        return StringUtils.splitString(s, start, end, DELIMITERS);
    }

    public static List<String> splitString(String s, int start, int end, String delimiters) {
        return StringUtils.splitString(s.toCharArray(), start, end, delimiters.toCharArray());
    }

    public static List<String> splitString(char[] s, char[] delimiters) {
        return StringUtils.splitString(s, 0, s.length, delimiters);
    }

    public static List<String> splitString(char[] s, int start, int end, char[] delimiters) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int p = start;
        while (p < end) {
            char c;
            if ((c = s[p++]) == '\\' && p < end) {
                sb.append(s[p++]);
                continue;
            }
            boolean isDelim = false;
            for (char delimiter : delimiters) {
                if (c != delimiter) continue;
                list.add(sb.toString());
                sb.setLength(0);
                isDelim = true;
            }
            if (isDelim) continue;
            sb.append(c);
        }
        if (sb.length() > 0 || list.isEmpty()) {
            list.add(sb.toString());
        }
        return list;
    }

    public static String escape(String s, char delimiter) {
        return s == null ? EMPTY : s.replaceAll("(\\\\|\\" + delimiter + ")", "\\\\$1");
    }

    public static String join(char delimiter, String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(StringUtils.escape(arg, delimiter)).append(delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String join(char delimiter, String[] args, int start, int end) {
        StringBuilder sb = new StringBuilder();
        for (int index = start; index < end; ++index) {
            sb.append(StringUtils.escape(args[index], delimiter)).append(delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String join(char delimiter, Collection<String> col) {
        return col == null || col.isEmpty() ? EMPTY : StringUtils.join(delimiter, col.toArray(new String[col.size()]));
    }

    public static String formalise(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : input.split(" ")) {
            if (s.length() <= 0) continue;
            sb.append(StringUtils.capitalise(s)).append(' ');
        }
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String capitaliseSentences(String input) {
        if (input == null) {
            return null;
        }
        input = StringUtils.normalise(input);
        StringBuilder sb = new StringBuilder();
        for (String s : input.split("\\.")) {
            if ((s = s.trim()).length() <= 0) continue;
            sb.append(StringUtils.capitalise(s)).append('.');
        }
        if (input.endsWith(".")) {
            while (sb.length() > 0 && sb.charAt(sb.length() - 1) == '.') {
                sb.setLength(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public static String normalise(String s) {
        return StringUtils.replaceAll(s, NORMALISE_REGEX);
    }

    public static String normaliseKeepLinefeed(String s) {
        return StringUtils.replaceAll(s, NORMALISE_REGEX2);
    }

    public static String replaceAll(String str, String[][] regex) {
        String s = str;
        if (s != null) {
            for (String[] p : regex) {
                s = s.replaceAll(p[0], p[1]);
            }
        }
        return s;
    }

    public static String removeNonAlphaNumeric(String s) {
        return s == null ? null : s.replaceAll("^[^A-Za-z0-9]+|[^A-Za-z0-9]+$", " ");
    }

    public static String plural(String s, String p, int value) {
        return value == 1 ? s : p;
    }

    public static String fix(int aValue, int aSize) {
        return String.format("%0" + aSize + "d", aValue);
    }

    public static int decodeHex(char aChar) {
        int ret = -1;
        if (aChar >= '0' && aChar <= '9') {
            ret = aChar - 48;
        } else if (aChar >= 'a' && aChar <= 'f') {
            ret = aChar - 97 + 10;
        } else if (aChar >= 'A' && aChar <= 'F') {
            ret = aChar - 65 + 10;
        } else {
            throw new IllegalArgumentException("Malformed hexadecimal " + aChar);
        }
        return ret;
    }

    public static char encodeHex(int value) {
        return hexHigh.charAt(value & 0xF);
    }

    public static String encodeHex(byte[] bytes) {
        if (bytes == null) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            sb.append(hexHigh.charAt(b >> 4 & 0xF)).append(hexHigh.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static byte[] decodeHex(String src) {
        if (src == null) {
            return new byte[0];
        }
        return StringUtils.decodeHex(src.toCharArray());
    }

    public static byte[] decodeHex(char[] c) {
        if (c.length % 2 == 1) {
            throw new IllegalArgumentException("Source hex must be an even number of characters");
        }
        byte[] b = new byte[c.length >> 1];
        int i = 0;
        int j = 0;
        while (i < c.length) {
            int v = StringUtils.decodeHex(c[i]) << 4 | StringUtils.decodeHex(c[i + 1]);
            b[j] = (byte)(v & 0xFF);
            i += 2;
            ++j;
        }
        return b;
    }

    public static String toString(Object object) {
        StringBuffer sbuf = new StringBuffer();
        if (object == null) {
            sbuf.append("null");
        } else {
            sbuf.append(object.getClass().getName()).append("=[");
            try {
                Method[] meths = object.getClass().getMethods();
                boolean sep = false;
                for (int i = 0; i < meths.length; ++i) {
                    String name;
                    Method meth = meths[i];
                    if ((meth.getModifiers() & 1) != 1 || meth.getParameterTypes().length != 0 || (name = meth.getName()).equals("getClass") || (name.length() <= 2 || !name.startsWith("is")) && (name.length() <= 3 || !name.startsWith("get"))) continue;
                    name = StringUtils.beanAccessor(name);
                    if (sep) {
                        sbuf.append(',');
                    }
                    sep = true;
                    sbuf.append(name).append("=\"");
                    sbuf.append(meth.invoke(object, new Object[0]));
                    sbuf.append('\"');
                }
            }
            catch (Exception ex) {
                sbuf.append("Exception " + ex.getMessage());
            }
            sbuf.append("]");
        }
        return sbuf.toString();
    }

    public static boolean continueLine(String aLine) {
        int slashCount = 0;
        int index = aLine.length() - 1;
        while (index >= 0 && aLine.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public static String decodeUnicode(String aString) {
        int len = aString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = aString.charAt(x++)) == 92) {
                if ((aChar = aString.charAt(x++)) == 117) {
                    int value = 0;
                    for (int i = 0; i < 4; ++i) {
                        value = (value << 4) + StringUtils.decodeHex(aString.charAt(x++));
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public static String encodeUnicode(String aString) {
        return StringUtils.encodeUnicode(aString, false);
    }

    public static String encodeUnicode(String aString, boolean escapeSpace) {
        int len = aString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = aString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\').append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\').append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\').append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\').append('u');
                        outBuffer.append(StringUtils.encodeHex(aChar >> 12 & 0xF));
                        outBuffer.append(StringUtils.encodeHex(aChar >> 8 & 0xF));
                        outBuffer.append(StringUtils.encodeHex(aChar >> 4 & 0xF));
                        outBuffer.append(StringUtils.encodeHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static int findNonWhitespace(String aString) {
        return StringUtils.findNonWhitespace(aString, 0);
    }

    public static int findNonWhitespace(String aString, int startIndex) {
        int len = aString.length();
        while (startIndex < len && whiteSpaceChars.indexOf(aString.charAt(startIndex)) != -1) {
            ++startIndex;
        }
        return startIndex;
    }

    public static int findKeySeparator(String aString, int keyStart) {
        int separatorIndex;
        int len = aString.length();
        for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
            char currentChar = aString.charAt(separatorIndex);
            if (currentChar == '\\') {
                ++separatorIndex;
                continue;
            }
            if (keyValueSeparators.indexOf(currentChar) != -1) break;
        }
        return separatorIndex;
    }

    public static int findKeyValue(String aString, int startIndex) {
        if (strictKeyValueSeparators.indexOf(aString.charAt(startIndex)) != -1) {
            ++startIndex;
        }
        return StringUtils.findNonWhitespace(aString, startIndex);
    }

    public static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.write(10);
    }

    public static String fixComment(String aComment) {
        String comment = aComment;
        if (comment == null || comment.equals(EMPTY)) {
            comment = EMPTY;
        } else {
            StringBuffer sbuf = new StringBuffer(aComment.length());
            StringTokenizer stok = new StringTokenizer(aComment, NLS);
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                if (!token.startsWith(COMMENT)) {
                    sbuf.append(COMMENT);
                }
                sbuf.append(token).append('\n');
            }
            if (sbuf.length() > 0 && sbuf.charAt(sbuf.length() - 1) != '\n') {
                sbuf.append('\n');
            }
            comment = sbuf.toString();
        }
        return comment;
    }

    public static String getUniqueKey(Map aMap, String aTitle) {
        String t = aTitle;
        while (aMap.containsKey(t = StringUtils.increment(t))) {
        }
        return t;
    }

    public static String increment(String s) {
        int p;
        for (p = s.length() - 1; p > -1 && Character.isDigit(s.charAt(p)); --p) {
        }
        String ret = null;
        ret = ++p == s.length() ? s + "1" : s.substring(0, p) + Integer.toString(Integer.parseInt(s.substring(p)) + 1);
        return ret;
    }

    public static int scanToken(String string, String delim, int start) {
        int p = string.length();
        for (int i = delim.length() - 1; i > -1; --i) {
            int q = string.indexOf(delim.charAt(i), start);
            if (q <= -1 || q >= p) continue;
            p = q;
        }
        return p == string.length() ? -1 : p;
    }

    @Deprecated
    public static final String getClassName(Class clazz) {
        return StringUtils.getClassName(clazz.getName());
    }

    public static final String getClassName(String c) {
        String ret = c;
        int i = c.lastIndexOf(46);
        if (i > -1) {
            ret = c.substring(i + 1);
        }
        return ret;
    }

    public static final String indentString(String s) {
        return StringUtils.indentStringBuffer(new StringBuffer(s)).toString();
    }

    public static final StringBuffer indentStringBuffer(StringBuffer sb) {
        int maxIndent = INDENT.length();
        int lineStart = 0;
        int nest = 0;
        boolean inQuote = false;
        boolean escaped = false;
        for (int p = 0; p < sb.length(); ++p) {
            char c = sb.charAt(p);
            if (!escaped) {
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == '\"') {
                    inQuote = !inQuote;
                    continue;
                }
                if (inQuote) continue;
                if (c == '{') {
                    ++nest;
                    continue;
                }
                if (c == '}') {
                    --nest;
                    boolean isSpace = true;
                    for (int i = lineStart; i < p && isSpace; ++i) {
                        isSpace = Character.isWhitespace(sb.charAt(i));
                    }
                    if (!isSpace) continue;
                    sb.delete(p - 4, p);
                    p -= 4;
                    continue;
                }
                if (c != '\n') continue;
                lineStart = p + 1;
                sb.insert(lineStart, INDENT.substring(0, Math.min(Math.max(0, 4 * nest), maxIndent)));
                continue;
            }
            escaped = false;
        }
        return sb;
    }

    public static String escapeString(String s) {
        return StringUtils.escapeStringBuffer(new StringBuffer(s)).toString();
    }

    public static StringBuffer escapeStringBuffer(StringBuffer sb) {
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c != '\\' && c != '\"' && c != '\'') continue;
            sb.insert(i, '\\');
            ++i;
        }
        return sb;
    }

    public static String unescapeString(String s) {
        return StringUtils.unescapeStringBuffer(new StringBuffer(s)).toString();
    }

    public static StringBuffer unescapeStringBuffer(StringBuffer sb) {
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c != '\\') continue;
            sb.delete(i, i + 1);
        }
        return sb;
    }

    public static String plainIndent(String aString, int aIndent) {
        return StringUtils.plainIndent(aString, aIndent, INDENT);
    }

    public static String plainIndent(String aString, int aIndent, String aIndentString) {
        StringBuffer sbuf = new StringBuffer();
        char[] indent = aIndentString.toCharArray();
        int len = aIndentString.length();
        while (aIndent >= len) {
            sbuf.append(indent);
            --aIndent;
        }
        if (aIndent > 0) {
            sbuf.append(indent, 0, aIndent);
        }
        return sbuf.append(aString).toString();
    }

    public static boolean isBeanAccessor(String name) {
        return name != null && (name.startsWith("get") || name.startsWith("is") || name.startsWith("set"));
    }

    public static String beanAccessor(String aName) {
        String name = null;
        int start = 0;
        if (aName.startsWith("get") || aName.startsWith("set")) {
            start = 3;
        } else if (aName.startsWith("is")) {
            start = 2;
        }
        if (start > 0 && aName.length() > start) {
            name = aName.substring(start, start + 1).toLowerCase();
            if (aName.length() - start > 0) {
                name = name + aName.substring(start + 1);
            }
        }
        return name;
    }

    public static String escapeXMLString(String s) {
        return StringUtils.escapeXMLStringBuffer(new StringBuffer(s)).toString();
    }

    public static StringBuffer escapeXMLStringBuffer(StringBuffer sb) {
        block5: for (int i = 0; i < sb.length(); ++i) {
            switch (sb.charAt(i)) {
                case '<': {
                    sb.replace(i, i + 1, "&lt;");
                    i += 3;
                    continue block5;
                }
                case '>': {
                    sb.replace(i, i + 1, "&gt;");
                    i += 3;
                    continue block5;
                }
                case '&': {
                    sb.replace(i, i + 1, "&amp;");
                    i += 4;
                    continue block5;
                }
            }
        }
        return sb;
    }

    public static String unescapeXMLString(String s) {
        return s.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
    }

    public static StringBuffer unescapeXMLStringBuffer(StringBuffer sb) {
        int l = sb.length();
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '&') {
                if (sb.substring(i, i + 4).equals("&lt;")) {
                    sb.replace(i, i + 4, "<");
                    ++i;
                } else if (sb.substring(i, i + 4).equals("&gt;")) {
                    sb.replace(i, i + 4, ">");
                    ++i;
                } else if (sb.substring(i, i + 5).equals("&amp;")) {
                    sb.replace(i, i + 5, "&");
                    ++i;
                }
            }
            ++i;
            --l;
        }
        return sb;
    }

    public static String escapeStringMS(String s) {
        return StringUtils.escapeStringBufferMS(new StringBuffer(s)).toString();
    }

    public static StringBuffer escapeStringBufferMS(StringBuffer sb) {
        block3: for (int i = 0; i < sb.length(); ++i) {
            switch (sb.charAt(i)) {
                case '\"': {
                    sb.insert(i, '\"');
                    ++i;
                    continue block3;
                }
            }
        }
        return sb;
    }

    public static String fromDos(String s) {
        if (StringUtils.isStringEmpty(s) || s.indexOf(13) == -1) {
            return s;
        }
        if ((s = s.replaceAll("\r\n", NLS)).indexOf(13) > -1) {
            s = s.replace('\r', '\n');
        }
        return s;
    }

    public static String toDos(String s) {
        if (StringUtils.isStringEmpty(s)) {
            return s;
        }
        return StringUtils.fromDos(s).replaceAll(NLS, "\r\n");
    }

    public static String baseName(String path) {
        return StringUtils.baseName(path, null);
    }

    public static String baseName(String path, String suffix) {
        if (path == null) {
            return null;
        }
        String name = path;
        int i = name.lastIndexOf(File.separatorChar);
        if (i > -1) {
            String string = name = i + 1 == name.length() ? EMPTY : name.substring(i + 1);
        }
        if (suffix != null && name.endsWith(suffix)) {
            int offset = suffix.startsWith(".") ? 0 : 1;
            name = name.substring(0, name.length() - suffix.length() - offset);
        }
        return name;
    }

    public static String stripFileSuffix(String path) {
        if (path == null) {
            return null;
        }
        String name = path;
        int i = name.lastIndexOf(File.separatorChar);
        if (i > -1) {
            String string = name = i + 1 == name.length() ? EMPTY : name.substring(i + 1);
        }
        if ((i = name.lastIndexOf(46)) > -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static String getFileSuffix(String path) {
        if (path == null) {
            return null;
        }
        String name = path;
        int i = name.lastIndexOf(File.separatorChar);
        if (i > -1) {
            name = i + 1 == name.length() ? EMPTY : name.substring(i + 1);
        }
        return (i = name.lastIndexOf(46)) > -1 ? name.substring(i + 1) : EMPTY;
    }

    public static String dirname(String path) {
        if (path == null) {
            return null;
        }
        int i = path.lastIndexOf(File.separatorChar);
        return i > -1 ? path.substring(0, i) : EMPTY;
    }

    public static StringBuilder readStringBuilder(File file) throws IOException {
        return StringUtils.readStringBuilder(new FileReader(file));
    }

    public static StringBuilder readStringBuilder(InputStream is) throws IOException {
        return StringUtils.readStringBuilder(new InputStreamReader(is));
    }

    public static StringBuilder readStringBuilder(URL url) throws IOException {
        return StringUtils.readStringBuilder(url.openStream());
    }

    public static StringBuilder readStringBuilder(Reader rdr) throws IOException {
        return StringUtils.readStringBuilder(new StringBuilder(), rdr);
    }

    public static StringBuilder readStringBuilder(StringBuilder sb, Reader rdr) throws IOException {
        char[] c = new char[1024];
        int s = rdr.read(c);
        while (s > -1) {
            sb.append(c, 0, s);
            s = rdr.read(c);
        }
        return sb;
    }

    public static String format(String format, Object ... args) {
        return args == null || args.length == 0 ? format : String.format(format, args);
    }

    public static int count(CharSequence source, char delimiter) {
        int length = source.length();
        int count = 0;
        for (int p = 0; p < length; ++p) {
            if (source.charAt(p) != delimiter) continue;
            ++count;
        }
        return count;
    }

    public static int countEscaped(CharSequence source, char delimiter) {
        int length = source.length();
        int count = 0;
        for (int p = 0; p < length; ++p) {
            char c = source.charAt(p);
            if (c == '\\') {
                ++p;
                continue;
            }
            if (c != delimiter) continue;
            ++count;
        }
        return count;
    }

    public static int count(char[] source, char delimiter) {
        int count = 0;
        for (int p = 0; p < source.length; ++p) {
            if (source[p] != delimiter) continue;
            ++count;
        }
        return count;
    }

    public static int countEscaped(char[] source, char delimiter) {
        int count = 0;
        for (int p = 0; p < source.length; ++p) {
            char c = source[p];
            if (c == '\\') {
                ++p;
                continue;
            }
            if (c != delimiter) continue;
            ++count;
        }
        return count;
    }

    public static String md5(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return StringUtils.encodeHex(md.digest(source.getBytes()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, List<String>> extractParameterMap(String queryString) throws UnsupportedEncodingException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (StringUtils.isStringNotEmpty(queryString)) {
            for (String s : queryString.split("&")) {
                String[] s1 = s.split("=", 2);
                if (s1.length != 2) continue;
                s1[0] = URLDecoder.decode(s1[0], UTF8_ENCODING);
                s1[1] = URLDecoder.decode(s1[1], UTF8_ENCODING);
                ArrayList<String> list = (ArrayList<String>)map.get(s1[0]);
                if (list == null) {
                    list = new ArrayList<String>();
                    map.put(s1[0], list);
                }
                list.add(s1[1]);
            }
        }
        return map;
    }

    public static Map<String, String> extractProperties(String source, String delimiters, String propertyPattern) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : StringUtils.splitString(source, delimiters)) {
            String[] s1 = s.trim().split(propertyPattern, 2);
            if (s1.length != 2) continue;
            map.put(s1[0], s1[1]);
        }
        return map;
    }

    public static void stripCommentsBlankLines(List<String> list) {
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            String s = it.next().trim();
            int i = s.indexOf(35);
            if (i == 0) {
                s = null;
            } else if (i > 0) {
                s = s.substring(0, i).trim();
            }
            if (!StringUtils.isStringEmpty(s)) continue;
            it.remove();
        }
    }

    public static String left(String s, int l) {
        if (s == null) {
            return null;
        }
        return s.substring(0, Math.min(s.length(), l));
    }

    public static String right(String s, int l) {
        if (s == null) {
            return null;
        }
        return s.substring(Math.max(0, s.length() - l));
    }

    public static String valueOf(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static String valueOf(Object obj, String defaultValue) {
        return obj == null ? defaultValue : obj.toString();
    }

    private static final boolean haveRoom(boolean sign, int start, int pos) {
        int idx = pos - 1;
        return sign ? idx > start : idx >= start;
    }

    public static void toCharArray(char[] buf, int value) {
        StringUtils.toCharArray(buf, value, 0, buf.length);
    }

    public static void toCharArray(char[] buf, int value, int start, int length) {
        StringUtils.toCharArray(buf, value, start, length, true);
    }

    public static void toCharArray(char[] buf, int value, int start, int length, boolean prefixZero) {
        StringUtils.toCharArrayImpl(buf, value, start, start + length, prefixZero);
    }

    private static void toCharArrayImpl(char[] buf, int value, int start, int end, boolean prefixZero) {
        int r;
        int q;
        int i = value;
        int charPos = end;
        boolean sign = false;
        if (i < 0) {
            sign = true;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = digits1[r];
            buf[--charPos] = digits10[r];
        }
        while (StringUtils.haveRoom(sign, start, charPos)) {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
            i = q;
            if (i != 0) continue;
        }
        if (prefixZero) {
            while (StringUtils.haveRoom(sign, start, charPos)) {
                buf[--charPos] = 48;
            }
        }
        if (sign) {
            buf[--charPos] = 45;
        }
    }

    public static void toCharArray(char[] buf, long value) {
        StringUtils.toCharArray(buf, value, 0, buf.length, true);
    }

    public static void toCharArray(char[] buf, long value, int start, int length) {
        StringUtils.toCharArray(buf, value, start, length, true);
    }

    public static void toCharArray(char[] buf, long value, int start, int length, boolean prefixZero) {
        StringUtils.toCharArrayImpl(buf, value, start, start + length, prefixZero);
    }

    private static void toCharArrayImpl(char[] buf, long value, int start, int end, boolean prefixZero) {
        int q2;
        int r;
        long i = value;
        int charPos = end;
        boolean sign = false;
        if (i < 0L) {
            sign = true;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = digits1[r];
            buf[--charPos] = digits10[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536 && StringUtils.haveRoom(sign, start, charPos)) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = digits1[r];
            buf[--charPos] = digits10[r];
        }
        while (StringUtils.haveRoom(sign, start, charPos)) {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r];
            i2 = q2;
            if (i2 != 0) continue;
        }
        if (prefixZero) {
            while (StringUtils.haveRoom(sign, start, charPos)) {
                buf[--charPos] = 48;
            }
        }
        if (sign) {
            buf[--charPos] = 45;
        }
    }

    public static String toSafeString(Object s) {
        return s == null ? EMPTY : s.toString();
    }
}

