/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.zip;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import uk.org.retep.logging.Log;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.io.zip.ZipFileVisitor;

public class ZipUtils {
    private ZipUtils() {
    }

    public static void createZip(File zipFile, List<File> files) throws IOException {
        ZipUtils.createZip(zipFile, null, files);
    }

    public static void createZip(File zipFile, File baseDirectory, FileFilter filter, boolean recurse) throws IOException {
        ZipUtils.createZip(zipFile, baseDirectory, FileUtils.findFiles(baseDirectory, filter, recurse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZip(File zipFile, File baseDirectory, List<File> files) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        try {
            ZipFileVisitor visitor = new ZipFileVisitor(zos, baseDirectory);
            FileUtils.visitFiles(visitor, files);
        }
        finally {
            zos.close();
        }
    }

    public static void createZip(Log log, File zipFile, List<File> files) throws IOException {
        ZipUtils.createZip(log, zipFile, null, files);
    }

    public static void createZip(Log log, File zipFile, File baseDirectory, FileFilter filter, boolean recurse) throws IOException {
        ZipUtils.createZip(log, zipFile, baseDirectory, FileUtils.findFiles(baseDirectory, filter, recurse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZip(Log log, File zipFile, File baseDirectory, List<File> files) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        try {
            ZipFileVisitor visitor = new ZipFileVisitor(log, zos, baseDirectory);
            FileUtils.visitFiles(visitor, files);
        }
        finally {
            zos.close();
        }
    }
}

