/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.File;
import java.io.IOException;
import uk.org.retep.logging.Log;
import uk.org.retep.util.io.FileVisitor;
import uk.org.retep.util.string.StringUtils;

public abstract class AbstractFileVisitor
implements FileVisitor {
    private final Log log;
    private final String message;

    public AbstractFileVisitor() {
        this(null, null);
    }

    public AbstractFileVisitor(Log log) {
        this(log, null);
    }

    public AbstractFileVisitor(Log log, String message) {
        this.log = log;
        this.message = StringUtils.isStringEmpty(message) ? "Modified %s" : message;
    }

    protected final void info(String msg, Object ... args) {
        if (this.log != null) {
            this.log.info(msg, args);
        }
    }

    protected final void warn(String msg, Object ... args) {
        if (this.log != null) {
            this.log.warn(msg, args);
        }
    }

    protected final void error(String msg, Object ... args) {
        if (this.log != null) {
            this.log.error(msg, args);
        }
    }

    protected final void fatal(String msg, Object ... args) {
        if (this.log != null) {
            this.log.fatal(msg, args);
        }
    }

    @Override
    public final boolean visit(File file) throws IOException {
        boolean ret = this.execute(file);
        if (ret) {
            this.info(this.message, file.getPath());
        }
        return ret;
    }

    protected abstract boolean execute(File var1) throws IOException;
}

