/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.collections.ConcurrencySupport;

@ThreadSafe
public class ConcurrentList<E>
extends ConcurrencySupport
implements List<E> {
    protected final List<E> list;

    public ConcurrentList(List<E> list) {
        this.list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void add(int index, E element) {
        this.writeLock().lock();
        try {
            this.list.add(index, element);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean add(E e) {
        this.writeLock().lock();
        try {
            boolean bl = this.list.add(e);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean addAll(Collection<? extends E> c) {
        this.writeLock().lock();
        try {
            boolean bl = this.list.addAll(c);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean addAll(int index, Collection<? extends E> c) {
        this.writeLock().lock();
        try {
            boolean bl = this.list.addAll(index, c);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void clear() {
        this.writeLock().lock();
        try {
            this.list.clear();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean contains(Object o) {
        this.readLock().lock();
        try {
            boolean bl = this.list.contains(o);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean containsAll(Collection<?> c) {
        this.readLock().lock();
        try {
            boolean bl = this.list.containsAll(c);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean equals(Object o) {
        this.readLock().lock();
        try {
            if (o instanceof ConcurrentList) {
                boolean bl = ((Object)this.list).equals(((ConcurrentList)ConcurrentList.class.cast((Object)o)).list);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public E get(int index) {
        this.readLock().lock();
        try {
            E e = this.list.get(index);
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public int hashCode() {
        this.readLock().lock();
        try {
            int n = ((Object)this.list).hashCode();
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public int indexOf(Object o) {
        this.readLock().lock();
        try {
            int n = this.list.indexOf(o);
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean isEmpty() {
        this.readLock().lock();
        try {
            boolean bl = this.list.isEmpty();
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public Iterator<E> iterator() {
        this.readLock().lock();
        try {
            final Iterator<E> it = this.list.iterator();
            Iterator iterator = new Iterator<E>(){

                @Override
                @ReadLock
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                @ReadLock
                public E next() {
                    return it.next();
                }

                @Override
                @WriteLock
                public void remove() {
                    it.remove();
                }
            };
            return iterator;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public int lastIndexOf(Object o) {
        this.readLock().lock();
        try {
            int n = this.list.lastIndexOf(o);
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public ListIterator<E> listIterator() {
        this.readLock().lock();
        try {
            ListIterator<E> listIterator = this.newListIterator(this.list.listIterator());
            return listIterator;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public ListIterator<E> listIterator(int index) {
        this.readLock().lock();
        try {
            ListIterator<E> listIterator = this.newListIterator(this.list.listIterator(index));
            return listIterator;
        }
        finally {
            this.readLock().unlock();
        }
    }

    private ListIterator<E> newListIterator(final ListIterator<E> li) {
        return new ListIterator<E>(){

            @Override
            @ReadLock
            public boolean hasNext() {
                return li.hasNext();
            }

            @Override
            @ReadLock
            public E next() {
                return li.next();
            }

            @Override
            @ReadLock
            public boolean hasPrevious() {
                return li.hasPrevious();
            }

            @Override
            @ReadLock
            public E previous() {
                return li.previous();
            }

            @Override
            @ReadLock
            public int nextIndex() {
                return li.nextIndex();
            }

            @Override
            @ReadLock
            public int previousIndex() {
                return li.previousIndex();
            }

            @Override
            @WriteLock
            public void remove() {
                li.remove();
            }

            @Override
            @WriteLock
            public void set(E element) {
                li.set(element);
            }

            @Override
            @WriteLock
            public void add(E element) {
                li.add(element);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E remove(int index) {
        this.writeLock().lock();
        try {
            E e = this.list.remove(index);
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean remove(Object o) {
        this.writeLock().lock();
        try {
            boolean bl = this.list.remove(o);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean removeAll(Collection<?> c) {
        this.writeLock().lock();
        try {
            boolean bl = this.list.removeAll(c);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean retainAll(Collection<?> c) {
        this.writeLock().lock();
        try {
            boolean bl = this.list.retainAll(c);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E set(int index, E element) {
        this.writeLock().lock();
        try {
            E e = this.list.set(index, element);
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public int size() {
        this.readLock().lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public List<E> subList(int fromIndex, int toIndex) {
        this.writeLock().lock();
        try {
            ConcurrentList<E> subList = new ConcurrentList<E>(this.list.subList(fromIndex, toIndex));
            subList.shareLock(this);
            ConcurrentList<E> concurrentList = subList;
            return concurrentList;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public Object[] toArray() {
        this.readLock().lock();
        try {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public <T> T[] toArray(T[] a) {
        this.readLock().lock();
        try {
            T[] TArray = this.list.toArray(a);
            return TArray;
        }
        finally {
            this.readLock().unlock();
        }
    }
}

