/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.logging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.jcip.annotations.ThreadSafe;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import uk.org.retep.annotations.Contract;
import uk.org.retep.annotations.DispatchThread;
import uk.org.retep.annotations.InvocationType;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;

@ThreadSafe
public class ListLogAppender
extends AppenderSkeleton
implements ListModel {
    private static final int MAX_ROWS = 500;
    private static Map<String, ListLogAppender> appenders = new ConcurrentHashMap<String, ListLogAppender>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private List<String> list = new ArrayList<String>();
    private Set<ListDataListener> listeners;
    private ListDataListener[] listenerCache;
    private int maxRows = 500;

    public static ListLogAppender getCollection(String name) {
        return appenders.get(name);
    }

    @Contract(value={ReadLock.class})
    private Lock readLock() {
        return this.lock.readLock();
    }

    @Contract(value={WriteLock.class})
    private Lock writeLock() {
        return this.lock.writeLock();
    }

    @ReadLock
    public int getMaxRows() {
        return this.maxRows;
    }

    @WriteLock
    public void setMaxRows(int maxRows) {
        this.maxRows = Math.min(100, maxRows);
    }

    @WriteLock
    public void setName(String name) {
        super.setName(name);
        appenders.put(name, this);
    }

    protected synchronized void append(LoggingEvent event) {
        this.append(this.layout.format(event));
    }

    @WriteLock
    private void append(String s) {
        int first = this.list.size() - 1;
        int l = s.length();
        int p = 0;
        int e = s.indexOf(10);
        while (e > p && p < l) {
            this.list.add(s.substring(p, e));
            p = e + 1;
            e = s.indexOf(10, p);
            if (first <= 0) continue;
            --first;
        }
        if (p < l) {
            this.list.add(s.substring(p));
        }
        if (this.list.size() > this.maxRows) {
            int d = this.list.size() - this.maxRows;
            while (this.list.size() > this.maxRows) {
                this.list.remove(0);
            }
            this.fireRemove(d);
        }
        this.fireAdd(first, this.list.size());
    }

    private void fireAdd(int s, int e) {
        this.fire(new ListDataEvent(this, 1, s, e));
    }

    private void fireRemove(int i) {
        this.fire(new ListDataEvent(this, 2, 0, i));
    }

    @DispatchThread(invocationType=InvocationType.INVOKE_LATER)
    private void fire(ListDataEvent e) {
        try {
            for (ListDataListener l : this.getListeners()) {
                l.intervalAdded(e);
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @WriteLock
    public void close() {
        this.list.clear();
    }

    public boolean requiresLayout() {
        return true;
    }

    @Override
    @ReadLock
    public int getSize() {
        return this.list.size();
    }

    @ReadLock
    public Object getElementAt(int index) {
        return this.list.get(index);
    }

    @Override
    @WriteLock
    public void addListDataListener(ListDataListener l) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ListDataListener>();
        }
        this.listeners.add(l);
        this.updateCache();
    }

    @Override
    @WriteLock
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    private void updateCache() {
        this.listenerCache = this.listeners.toArray(new ListDataListener[this.listeners.size()]);
    }

    @ReadLock
    private ListDataListener[] getListeners() {
        return this.listenerCache;
    }
}

