/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.state;

import uk.org.retep.util.string.StringUtils;

public enum TriState {
    DEFAULT,
    FALSE,
    TRUE;


    public boolean booleanValue() {
        return this.booleanValue(false);
    }

    public boolean booleanValue(boolean defaultValue) {
        switch (this) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
        }
        return defaultValue;
    }

    public boolean booleanValue(TriState defaultValue) {
        switch (this) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
        }
        return defaultValue.booleanValue(false);
    }

    public static TriState valueOfDefault(String s) {
        try {
            return TriState.valueOf(s);
        }
        catch (Exception e) {
            return DEFAULT;
        }
    }

    public static TriState valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static TriState valueOf(Boolean b) {
        return b == null ? DEFAULT : TriState.valueOf((boolean)b);
    }

    public <T> T choice(T t, T f, T d) {
        return d;
    }

    public final String choice(String d) {
        return this.choice("true", "false", d);
    }

    public final String choiceYN(String d) {
        return this.choice("yes", "no", d);
    }

    public static TriState parseBoolean(String s) {
        if (StringUtils.isStringEmpty(s)) {
            return DEFAULT;
        }
        char c = s.charAt(0);
        if (c == 't' || c == 'T' || c == 'y' || c == 'Y' || c == '1') {
            return TRUE;
        }
        if (c == 'f' || c == 'F' || c == 'n' || c == 'N' || c == '0') {
            return FALSE;
        }
        return DEFAULT;
    }
}

