/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.jcip.annotations.NotThreadSafe;
import uk.org.retep.util.collections.list.ListFacade;
import uk.org.retep.util.reflect.Invocation;

@NotThreadSafe
public class InvocationList
extends ListFacade<Invocation> {
    private static final long serialVersionUID = 6196804275234605279L;

    public InvocationList() {
        super(new ArrayList());
    }

    public Object invoke(int index, Object ... args) throws Exception {
        try {
            return ((Invocation)this.get(index)).invoke(args);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t != null && t instanceof Exception) {
                throw (Exception)Exception.class.cast(t);
            }
            throw ite;
        }
    }

    public void invokeAll(Object ... args) throws Exception {
        try {
            for (Invocation invocation : this) {
                invocation.invoke(args);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t != null && t instanceof Exception) {
                throw (Exception)Exception.class.cast(t);
            }
            throw ite;
        }
    }

    public void add(Object bean, String method, Class ... parameterTypes) throws NoSuchMethodException {
        this.add(new Invocation(bean, method, parameterTypes));
    }

    public <T extends Annotation> void addAnnotation(Object bean, Class<T> annotationClass) {
        for (Method m : bean.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotationClass)) continue;
            this.add(new Invocation(bean, m));
        }
    }

    public <T extends Annotation> void addAnnotation(int index, Object bean, Class<T> annotationClass) {
        for (Method m : bean.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotationClass)) continue;
            this.add(index, new Invocation(bean, m));
        }
    }
}

