/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio.charset;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import uk.org.retep.annotations.Encoding;
import uk.org.retep.util.nio.charset.Charset;

public class CharsetFactory {
    private static Map<String, Charset> charsets;

    private CharsetFactory() {
    }

    private static synchronized Map<String, Charset> getCharsets() {
        if (charsets == null) {
            charsets = new HashMap<String, Charset>();
            for (Charset c : ServiceLoader.load(Charset.class, Thread.currentThread().getContextClassLoader())) {
                Encoding e = c.getClass().getAnnotation(Encoding.class);
                if (e == null) continue;
                for (String enc : e.value()) {
                    if (charsets.containsKey(enc)) continue;
                    charsets.put(enc, c);
                }
            }
        }
        return charsets;
    }

    public static Charset getCharset(String encoding) {
        Charset c = CharsetFactory.getCharsets().get(encoding);
        return c == null ? null : c.getInstance();
    }
}

