/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio.charset;

import java.nio.ByteBuffer;
import uk.org.retep.util.nio.charset.AbstractCharset;
import uk.org.retep.util.nio.charset.Charset;

public abstract class AbstractUTF_16
extends AbstractCharset {
    public static final char BYTE_ORDER_MARK = '\ufeff';
    public static final char REVERSED_MARK = '\ufffe';

    @Override
    public abstract Charset getInstance();

    protected final char decodeBig(int b1, int b2) {
        return (char)(b1 << 8 | b2);
    }

    protected final char decodeLittle(int b1, int b2) {
        return (char)(b2 << 8 | b1);
    }

    protected final boolean encodeBig(ByteBuffer buffer, char c) {
        if (buffer.remaining() < 2) {
            return false;
        }
        buffer.put((byte)(c >> 8));
        buffer.put((byte)(c & 0xFF));
        return true;
    }

    protected final boolean encodeLittle(ByteBuffer buffer, char c) {
        if (buffer.remaining() < 2) {
            return false;
        }
        buffer.put((byte)(c & 0xFF));
        buffer.put((byte)(c >> 8));
        return true;
    }

    @Override
    public int size(char c) {
        return 2;
    }
}

