/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.nio.DelegatingSocketProcessor;
import uk.org.retep.util.nio.SocketProcessorHandler;

@ThreadSafe
public abstract class DelegatingPoolSocketProcessor
extends DelegatingSocketProcessor {
    private Map<SocketChannel, SocketProcessorHandler> handlers = new HashMap<SocketChannel, SocketProcessorHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    protected final SocketProcessorHandler createSocketProcessorHandler(SocketChannel channel) {
        this.writeLock().lock();
        try {
            SocketProcessorHandler handler = this.handlers.get(channel);
            if (handler == null) {
                handler = this.createSocketProcessorHandlerImpl(channel);
                this.handlers.put(channel, handler);
            }
            SocketProcessorHandler socketProcessorHandler = handler;
            return socketProcessorHandler;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    protected abstract SocketProcessorHandler createSocketProcessorHandlerImpl(SocketChannel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    protected final SocketProcessorHandler getSocketProcessorHandler(SocketChannel channel) {
        this.readLock().lock();
        try {
            SocketProcessorHandler socketProcessorHandler = this.handlers.get(channel);
            return socketProcessorHandler;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    protected void cancel(SelectionKey key) {
        SocketChannel channel = (SocketChannel)key.channel();
        SocketProcessorHandler handler = this.getSocketProcessorHandler(channel);
        if (handler != null) {
            handler.close(channel);
        }
        super.cancel(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    protected final void closeSocketProcessorHandler(SocketProcessorHandler handler, SocketChannel channel) {
        this.writeLock().lock();
        try {
            this.handlers.remove(channel);
        }
        finally {
            this.writeLock().unlock();
        }
    }
}

