/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.WritableByteChannel;
import uk.org.retep.util.io.tar.TarArchiveTracker;
import uk.org.retep.util.io.tar.TarHeader;
import uk.org.retep.util.io.tar.WritableTar;

public class WritableTarChannel
implements Channel,
WritableByteChannel,
WritableTar {
    private final WritableByteChannel channel;
    private final TarArchiveTracker tracker;

    public WritableTarChannel(WritableByteChannel channel) {
        this.channel = channel;
        this.tracker = new TarArchiveTracker(this){

            @Override
            public void write(ByteBuffer buffer) throws IOException {
                WritableTarChannel.this.write(buffer);
            }
        };
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.tracker.closeArchive();
        this.channel.close();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int c = this.channel.write(src);
        this.tracker.recordBytesWritten(c);
        return c;
    }

    @Override
    public void putNextEntry(TarHeader header) throws IOException {
        this.closeEntry();
        ByteBuffer buffer = header.allocateTarHeader();
        header.put(buffer);
        buffer.rewind();
        while (buffer.remaining() > 0) {
            this.write(buffer);
        }
    }

    @Override
    public void closeEntry() throws IOException {
        this.tracker.closeEntry();
    }
}

