/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import uk.org.retep.logging.Log;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.io.bzip2.BZip2OutputStream;
import uk.org.retep.util.io.tar.TarCreateFileVisitor;
import uk.org.retep.util.io.tar.TarOutputStream;

public class TarUtils {
    private TarUtils() {
    }

    public static void createTar(File tarFile, List<File> files) throws IOException {
        TarUtils.createTar(null, tarFile, null, files);
    }

    public static void createTar(File tarFile, File baseDirectory, FileFilter filter, boolean recurse) throws IOException {
        TarUtils.createTar(null, tarFile, baseDirectory, FileUtils.findFiles(baseDirectory, filter, recurse));
    }

    public static void createTar(File tarFile, File baseDirectory, List<File> files) throws IOException {
        TarUtils.createTar(null, tarFile, baseDirectory, files);
    }

    public static void createTar(Log log, File tarFile, List<File> files) throws IOException {
        TarUtils.createTar(log, tarFile, null, files);
    }

    public static void createTar(Log log, File tarFile, File baseDirectory, FileFilter filter, boolean recurse) throws IOException {
        TarUtils.createTar(log, tarFile, baseDirectory, FileUtils.findFiles(baseDirectory, filter, recurse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTar(Log log, File tarFile, File baseDirectory, List<File> files) throws IOException {
        OutputStream os = new FileOutputStream(tarFile);
        try {
            String name = tarFile.getName();
            if (name.endsWith(".tar.gz") || name.endsWith(".tgz")) {
                os = new GZIPOutputStream(os);
            } else if (name.endsWith(".tar.bz2")) {
                os = new BZip2OutputStream(os);
            }
            TarOutputStream zos = new TarOutputStream(os);
            try {
                TarCreateFileVisitor visitor = TarCreateFileVisitor.createVisitor(log, zos);
                visitor.setBaseDir(baseDirectory);
                FileUtils.visitFiles(visitor, files);
            }
            finally {
                zos.close();
            }
        }
        finally {
            os.flush();
            os.close();
        }
    }
}

