/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public enum TarHeaderType {
    REGULAR_FILE('0'),
    AREGULAR_FILE('\u0000'),
    LINK('1'),
    SYM('2'),
    CHARACTER_SPECIAL('3'),
    BLOCK_SPECIAL('4'),
    DIRECTORY('5'),
    FIFO('6'),
    CONTTYPE('7'),
    XHDTYPE('x'),
    XGLTYPE('g'),
    SOLARIS_ACL('A'),
    USER_B('B'),
    USER_C('C'),
    GNU_DUMPDIR('D'),
    SOLARIS_EAF('E'),
    USER_F('F'),
    USER_G('G'),
    USER_H('H'),
    INODE_ONLY('I'),
    USER_J('J'),
    GNU_LONGLINK('K'),
    GNU_LONGNAME('L'),
    GNU_MULTIVOL('M'),
    OBSOLETE_GNU('N'),
    USER_O('O'),
    USER_P('P'),
    USER_Q('Q'),
    USER_R('R'),
    GNU_SPARSE('S'),
    USER_T('T'),
    USER_U('U'),
    GNU_VOLUME_HEADER('V'),
    USER_W('W'),
    POSIX_SOALRIS_EXTENDED('X'),
    USER_Y('Y'),
    USER_Z('Z');

    private final char type;
    private static final Map<Character, TarHeaderType> lookup;

    private TarHeaderType(char type) {
        this.type = type;
    }

    public char getType() {
        return this.type;
    }

    public void put(ByteBuffer buffer) {
        buffer.put((byte)this.type);
    }

    public static void skip(ByteBuffer buffer) {
        buffer.get();
    }

    public static TarHeaderType valueOf(ByteBuffer buffer) {
        char type = (char)buffer.get();
        TarHeaderType value = lookup.get(Character.valueOf(type));
        if (value == null) {
            throw new IllegalArgumentException("Unsupported type " + type);
        }
        return value;
    }

    static {
        lookup = new HashMap<Character, TarHeaderType>();
        for (TarHeaderType type : TarHeaderType.values()) {
            lookup.put(Character.valueOf(type.type), type);
        }
    }
}

