/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.File;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import uk.org.retep.logging.Log;
import uk.org.retep.util.io.AbstractFileVisitor;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.io.tar.TarFactory;
import uk.org.retep.util.io.tar.TarOutputStream;
import uk.org.retep.util.io.tar.WritableTar;
import uk.org.retep.util.io.tar.WritableTarChannel;
import uk.org.retep.util.string.StringUtils;

public abstract class TarCreateFileVisitor
extends AbstractFileVisitor {
    private static final String DEFAULT_MESSAGE = "Added %s to tar";
    private String baseDir;
    private String dirPrefix;
    private final WritableTar wt;

    public static TarCreateFileVisitor createVisitor(TarOutputStream tos) {
        return TarCreateFileVisitor.createVisitor((Log)null, null, tos);
    }

    public static TarCreateFileVisitor createVisitor(Log log, TarOutputStream tos) {
        return TarCreateFileVisitor.createVisitor(log, null, tos);
    }

    public static TarCreateFileVisitor createVisitor(Log log, String message, final TarOutputStream tos) {
        return new TarCreateFileVisitor(log, message == null ? DEFAULT_MESSAGE : message, tos){

            @Override
            protected void copyFile(File file) throws IOException {
                FileUtils.copyFile(file, tos);
            }
        };
    }

    public static TarCreateFileVisitor createVisitor(WritableTarChannel wt) {
        return TarCreateFileVisitor.createVisitor((Log)null, null, wt);
    }

    public static TarCreateFileVisitor createVisitor(Log log, WritableTarChannel wt) {
        return TarCreateFileVisitor.createVisitor(log, null, wt);
    }

    public static TarCreateFileVisitor createVisitor(Log log, String message, final WritableTarChannel wt) {
        return new TarCreateFileVisitor(log, message == null ? DEFAULT_MESSAGE : message, wt){

            @Override
            protected void copyFile(File file) throws IOException {
                FileUtils.transferFrom(file, (WritableByteChannel)wt);
            }
        };
    }

    public TarCreateFileVisitor(Log log, String message, WritableTar wt) {
        super(log, message);
        this.wt = wt;
    }

    protected abstract void copyFile(File var1) throws IOException;

    public void setDirPrefix(String dirPrefix) {
        this.dirPrefix = dirPrefix == null || dirPrefix.endsWith("/") ? dirPrefix : dirPrefix + "/";
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir == null ? "" : baseDir;
    }

    public void setBaseDir(File baseDir) throws IOException {
        this.baseDir = baseDir == null ? "" : baseDir.getCanonicalPath();
    }

    @Override
    protected boolean execute(File file) throws IOException {
        String name = file.getCanonicalPath();
        name = this.baseDir != null && name.startsWith(this.baseDir) ? name.substring(this.baseDir.length() + 1) : file.getName();
        if (StringUtils.isStringNotEmpty(this.dirPrefix)) {
            name = this.dirPrefix + name;
        }
        if (file.isDirectory()) {
            this.wt.putNextEntry(TarFactory.createDirectory(name, file.lastModified()));
        } else {
            this.wt.putNextEntry(TarFactory.createFile(file, name));
            this.copyFile(file);
            this.wt.closeEntry();
        }
        return true;
    }
}

