/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.queue;

import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.thread.DelayedRunnable;

@ThreadSafe
public class DelayedBlockingQueue
extends AbstractCollection<Runnable>
implements BlockingQueue<Runnable> {
    private final DelayQueue<DelayedRunnable> dq;
    private final Lock lock;

    public DelayedBlockingQueue() {
        this(new DelayQueue());
    }

    public DelayedBlockingQueue(DelayQueue<? extends DelayedRunnable> dq) {
        this.dq = dq;
        Lock lck = null;
        try {
            for (Field f : dq.getClass().getDeclaredFields()) {
                if (!"lock".equals(f.getName())) continue;
                f.setAccessible(true);
                lck = (Lock)f.get(dq);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (lck == null) {
            throw new InstantiationError("Unable to access lock");
        }
        this.lock = lck;
    }

    @Override
    public Runnable poll() {
        return (Runnable)this.dq.poll();
    }

    @Override
    public Runnable peek() {
        return (Runnable)this.dq.peek();
    }

    @Override
    public Runnable take() throws InterruptedException {
        return (Runnable)this.dq.take();
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (Runnable)this.dq.poll(timeout, unit);
    }

    @Override
    public boolean add(Runnable x) {
        assert (this.offer(x));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Runnable x) {
        if (!(x instanceof DelayedRunnable)) {
            throw new ClassCastException("Runnable does not implement DelayedRunnable interface");
        }
        this.lock.lock();
        try {
            this.dq.remove(x);
            boolean bl = this.dq.offer((DelayedRunnable)((Delayed)DelayedRunnable.class.cast(x)));
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void put(Runnable x) {
        this.offer(x);
    }

    @Override
    public boolean offer(Runnable x, long timeout, TimeUnit unit) {
        return this.offer(x);
    }

    @Override
    public Runnable remove() {
        return (Runnable)this.dq.remove();
    }

    @Override
    public Runnable element() {
        return (Runnable)this.dq.element();
    }

    @Override
    public void clear() {
        this.dq.clear();
    }

    @Override
    public int drainTo(Collection<? super Runnable> c) {
        return this.dq.drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        return this.dq.drainTo(c, maxElements);
    }

    @Override
    public int remainingCapacity() {
        return this.dq.remainingCapacity();
    }

    @Override
    public boolean remove(Object x) {
        return this.dq.remove(x);
    }

    @Override
    public boolean contains(Object x) {
        return this.dq.contains(x);
    }

    @Override
    public int size() {
        return this.dq.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dq.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.dq.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.dq.toArray(array);
    }

    @Override
    public Iterator<Runnable> iterator() {
        Iterator<Runnable> it = this.dq.iterator();
        return it;
    }
}

