/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import uk.org.retep.util.annotation.AbstractServiceProcessor;
import uk.org.retep.util.javac.JavacUtils;
import uk.org.retep.util.string.StringUtils;

@SupportedAnnotationTypes(value={"javax.ws.rs.Path"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class RestProcessor
extends AbstractServiceProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        if (env.processingOver()) {
            return true;
        }
        JavacUtils utils = new JavacUtils(this.processingEnv, env);
        boolean ret = false;
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annoElements = utils.env.getElementsAnnotatedWith(typeElement);
            for (Element element : annoElements) {
                this.processAnnotation(utils, element);
            }
            ret |= !annoElements.isEmpty();
        }
        try {
            this.writeServices(utils);
        }
        catch (IOException ex) {
            utils.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
        }
        return ret;
    }

    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        throw new UnsupportedOperationException("Not used");
    }

    @Override
    protected void processAnnotation(JavacUtils utils, Element e) {
        TypeElement te = JavacUtils.findEnclosingTypeElement(e);
        this.registerService(utils, "javax/ws/rs/core/Path", JavacUtils.getClassFileName(te));
    }

    @Override
    protected String getServiceName(String fileName) {
        return StringUtils.baseName(fileName);
    }
}

