/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.annotation;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import uk.org.retep.annotations.Lock;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.javac.JavacUtils;

@SupportedAnnotationTypes(value={"uk.org.retep.annotations.Lock", "uk.org.retep.annotations.ReadLock", "uk.org.retep.annotations.WriteLock"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ReadWriteLockProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        JavacUtils utils = new JavacUtils(this.processingEnv, env);
        boolean claimed = false;
        for (Generator generator : Generator.values()) {
            claimed = this.process(generator, utils);
        }
        return claimed;
    }

    private boolean process(Generator generator, JavacUtils utils) {
        Set<? extends Element> annoElements = utils.env.getElementsAnnotatedWith(generator.getAnnotationClass());
        for (Element element : annoElements) {
            generator.process(utils, element);
        }
        return !annoElements.isEmpty();
    }

    private static enum Generator {
        LOCK(Lock.class, "lock"),
        READ(ReadLock.class, "readLock"),
        WRITE(WriteLock.class, "writeLock");

        private final Class<? extends Annotation> clazz;
        private final String methodName;

        private Generator(Class<? extends Annotation> clazz, String methodName) {
            this.clazz = clazz;
            this.methodName = methodName;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.clazz;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void process(JavacUtils utils, Element e) {
            ExecutableElement type = JavacUtils.findEnclosingExecutableElement(e);
            if (type == null) {
                utils.messager.printMessage(Diagnostic.Kind.ERROR, "Only methods can be annotated with @" + this.getAnnotationClass().getSimpleName(), e);
                return;
            }
            TypeElement classType = JavacUtils.findEnclosingTypeElement(e);
            JCTree.JCMethodDecl md = (JCTree.JCMethodDecl)JCTree.JCMethodDecl.class.cast(utils.trees.getTree(type));
            int pos = md.pos;
            Type readWriteType = utils.qualIdentAndLoad(ReadWriteLock.class).type;
            Type lockType = utils.qualIdentAndLoad(java.util.concurrent.locks.Lock.class).type;
            JCTree.JCMethodInvocation lockGet = utils.call(classType, pos, utils.fromString(this.methodName), readWriteType, List.<JCTree.JCExpression>nil());
            JCTree.JCStatement lock = (JCTree.JCStatement)JCTree.JCStatement.class.cast(utils.make.Exec(utils.makeCall(classType, md.pos(), pos, lockGet, lockType, utils.fromString("lock"), List.<JCTree.JCExpression>nil())));
            JCTree.JCMethodInvocation unlockGet = utils.call(classType, pos, utils.fromString(this.methodName), readWriteType, List.<JCTree.JCExpression>nil());
            JCTree.JCStatement unlock = (JCTree.JCStatement)JCTree.JCStatement.class.cast(utils.make.Exec(utils.makeCall(classType, md.pos(), pos, unlockGet, lockType, utils.fromString("unlock"), List.<JCTree.JCExpression>nil())));
            List<JCTree.JCStatement> statements = List.of(lock, utils.make.Try(md.getBody(), List.<JCTree.JCCatch>nil(), utils.block(0, unlock)));
            md.body = utils.make.Block(0L, statements);
        }
    }
}

