/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.table;

import java.io.Serializable;
import uk.org.retep.util.graphics.TextAlignment;

public class Cell
implements Serializable {
    static final long serialVersionUID = -5827635216362209058L;
    private TextAlignment alignment = TextAlignment.LEFT;
    private String value;
    private String style;
    private String styleClass;
    private int index;
    private int colspan = 1;
    private int rowspan = 1;
    private boolean mergeLeft;
    private boolean mergeAbove;

    public Cell() {
    }

    public Cell(String value) {
        this(value, null);
    }

    public Cell(String value, String style) {
        this.value = value;
        this.style = style;
    }

    public TextAlignment getTextAlignment() {
        return this.alignment;
    }

    public void setTextAlignment(TextAlignment alignment) {
        this.alignment = alignment;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.mergeAbove = false;
        this.mergeLeft = false;
        this.value = value;
    }

    public boolean containsContent() {
        return !this.mergeAbove && !this.mergeLeft && this.value != null;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String value) {
        this.style = value;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String value) {
        this.styleClass = value;
    }

    public int getColSpan() {
        return this.colspan;
    }

    public void setColSpan(int colspan) {
        this.colspan = colspan;
    }

    public int getRowSpan() {
        return this.rowspan;
    }

    public void setRowSpan(int rowspan) {
        this.rowspan = rowspan;
    }

    public boolean isMergeLeft() {
        return this.mergeLeft;
    }

    public void setMergeLeft(boolean mergeLeft) {
        this.mergeAbove = false;
        this.mergeLeft = mergeLeft;
        this.value = "";
    }

    public boolean isMergeAbove() {
        return this.mergeAbove;
    }

    public void setMergeAbove(boolean mergeAbove) {
        this.mergeAbove = mergeAbove;
        this.mergeLeft = false;
        this.value = "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("index=").append(this.index);
        sb.append(",colspan=").append(this.colspan);
        sb.append(",rowspan=").append(this.rowspan);
        sb.append(",style=").append(this.style);
        sb.append(",value=").append(this.value);
        sb.append(']');
    }
}

