/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.unit;

import uk.org.retep.util.unit.AngleUnit;

public enum LengthUnit {
    INCH{

        public double convert(double a, LengthUnit u) {
            return u.toInch(a);
        }

        @Override
        public String getName() {
            return "Inch";
        }

        @Override
        public String getSymbol() {
            return "in";
        }

        @Override
        public char unitChar() {
            return '?';
        }

        @Override
        public boolean isSI() {
            return false;
        }

        @Override
        public double toMetre(double l) {
            return l * 0.0254;
        }

        @Override
        public double toInch(double l) {
            return l;
        }

        @Override
        public double toFoot(double l) {
            return l * 12.0;
        }

        @Override
        public double toMile(double l) {
            return l / 63360.0;
        }

        @Override
        public double toYard(double l) {
            return l * 36.0;
        }
    }
    ,
    FOOT{

        public double convert(double a, LengthUnit u) {
            return u.toFoot(a);
        }

        @Override
        public String getName() {
            return "Foot";
        }

        @Override
        public String getSymbol() {
            return "ft";
        }

        @Override
        public char unitChar() {
            return '?';
        }

        @Override
        public boolean isSI() {
            return false;
        }

        @Override
        public double toMetre(double l) {
            return l * 0.3048;
        }

        @Override
        public double toInch(double l) {
            return l * 12.0;
        }

        @Override
        public double toFoot(double l) {
            return l;
        }

        @Override
        public double toMile(double l) {
            return l / 5280.0;
        }

        @Override
        public double toYard(double l) {
            return l / 3.0;
        }
    }
    ,
    MILE{

        public double convert(double a, LengthUnit u) {
            return u.toMile(a);
        }

        @Override
        public String getName() {
            return "Mile";
        }

        @Override
        public String getSymbol() {
            return "mil";
        }

        @Override
        public char unitChar() {
            return '?';
        }

        @Override
        public boolean isSI() {
            return false;
        }

        @Override
        public double toMetre(double l) {
            return l * 1609.344;
        }

        @Override
        public double toInch(double l) {
            return l * 63360.0;
        }

        @Override
        public double toFoot(double l) {
            return l * 5280.0;
        }

        @Override
        public double toMile(double l) {
            return l;
        }

        @Override
        public double toYard(double l) {
            return l * 1760.0;
        }
    }
    ,
    YARD{

        public double convert(double a, LengthUnit u) {
            return u.toYard(a);
        }

        @Override
        public String getName() {
            return "Yard";
        }

        @Override
        public String getSymbol() {
            return "yd";
        }

        @Override
        public char unitChar() {
            return '?';
        }

        @Override
        public boolean isSI() {
            return false;
        }

        @Override
        public double toMetre(double l) {
            return l * 0.9144;
        }

        @Override
        public double toInch(double l) {
            return l / 36.0;
        }

        @Override
        public double toFoot(double l) {
            return l * 3.0;
        }

        @Override
        public double toMile(double l) {
            return l / 1760.0;
        }

        @Override
        public double toYard(double l) {
            return l;
        }
    }
    ,
    METRE{

        public double convert(double a, LengthUnit u) {
            return u.toMetre(a);
        }

        @Override
        public String getName() {
            return "METRE";
        }

        public String getDefinition() {
            return "";
        }

        @Override
        public String getSymbol() {
            return "m";
        }

        @Override
        public char unitChar() {
            return 'm';
        }

        @Override
        public boolean isSI() {
            return true;
        }

        @Override
        public double toMetre(double l) {
            return l;
        }

        @Override
        public double toInch(double l) {
            return l / 0.0254;
        }

        @Override
        public double toFoot(double l) {
            return l / 0.3048;
        }

        @Override
        public double toMile(double l) {
            return l / 1609.344;
        }

        @Override
        public double toYard(double l) {
            return l / 0.9144;
        }
    }
    ,
    METRIC_CUBIT{

        public double convert(double a, LengthUnit u) {
            return u.toMetricCubit(a);
        }

        @Override
        public String getName() {
            return "Metric Cubit";
        }

        @Override
        public String getSymbol() {
            return "cubit";
        }

        @Override
        public char unitChar() {
            return '?';
        }

        @Override
        public boolean isSI() {
            return false;
        }

        @Override
        public double toMetre(double l) {
            return l / 2.0;
        }

        @Override
        public double toInch(double l) {
            return METRE.toInch(this.toMetre(l));
        }

        @Override
        public double toMetricCubit(double l) {
            return l;
        }

        @Override
        public double toFoot(double l) {
            return METRE.toFoot(this.toMetre(l));
        }

        @Override
        public double toMile(double l) {
            return METRE.toMile(this.toMetre(l));
        }

        @Override
        public double toYard(double l) {
            return METRE.toYard(this.toMetre(l));
        }
    }
    ,
    ROMAN_CUBIT{

        public double convert(double a, LengthUnit u) {
            return u.toRomanCubit(a);
        }

        @Override
        public String getName() {
            return "Roman Cubit";
        }

        @Override
        public String getSymbol() {
            return "cubit";
        }

        @Override
        public char unitChar() {
            return '?';
        }

        @Override
        public boolean isSI() {
            return false;
        }

        @Override
        public double toMetre(double l) {
            return l * 444.5;
        }

        @Override
        public double toInch(double l) {
            return METRE.toInch(this.toMetre(l));
        }

        @Override
        public double toRomanCubit(double l) {
            return l;
        }

        @Override
        public double toFoot(double l) {
            return METRE.toFoot(this.toMetre(l));
        }

        @Override
        public double toMile(double l) {
            return METRE.toMile(this.toMetre(l));
        }

        @Override
        public double toYard(double l) {
            return METRE.toYard(this.toMetre(l));
        }
    };

    public static final char UNICODE_UNSUPPORTED = '?';

    public double convert(double sourceLength, AngleUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public String getName() {
        throw new AbstractMethodError();
    }

    public String getSymbol() {
        throw new AbstractMethodError();
    }

    public char unitChar() {
        return '?';
    }

    public boolean isSI() {
        return true;
    }

    public double toMetre(double l) {
        throw new AbstractMethodError();
    }

    public double toMetricCubit(double l) {
        return this.toMetre(l) * 2.0;
    }

    public double toRomanCubit(double l) {
        return this.toMetre(l) / 0.4445;
    }

    public double toInch(double l) {
        throw new AbstractMethodError();
    }

    public double toFoot(double l) {
        throw new AbstractMethodError();
    }

    public double toMile(double l) {
        throw new AbstractMethodError();
    }

    public double toYard(double l) {
        throw new AbstractMethodError();
    }
}

