/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.monitor;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import uk.org.retep.util.collections.ConcurrencySupport;
import uk.org.retep.util.monitor.ProgressListener;

public class ProgressListenerSet
extends ConcurrencySupport
implements ProgressListener {
    private static final Lock lock = new ReentrantLock();
    private Set<ProgressListener> listeners = new HashSet<ProgressListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProgressListener add(ProgressListener current, ProgressListener listener) {
        lock.lock();
        try {
            if (listener == null) {
                throw new IllegalArgumentException("ProgressListener may not be null");
            }
            if (current == null) {
                ProgressListener progressListener = listener;
                return progressListener;
            }
            if (current instanceof ProgressListenerSet) {
                ((ProgressListenerSet)ProgressListenerSet.class.cast(current)).add(listener);
                ProgressListener progressListener = current;
                return progressListener;
            }
            ProgressListenerSet progressListenerSet = new ProgressListenerSet(listener);
            return progressListenerSet;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProgressListener remove(ProgressListener current, ProgressListener listener) {
        lock.lock();
        try {
            if (listener == null) {
                throw new IllegalArgumentException("ProgressListener may not be null");
            }
            if (current != null && current instanceof ProgressListenerSet) {
                ((ProgressListenerSet)ProgressListenerSet.class.cast(current)).remove(listener);
            }
            ProgressListener progressListener = current;
            return progressListener;
        }
        finally {
            lock.unlock();
        }
    }

    public ProgressListenerSet() {
    }

    public ProgressListenerSet(ProgressListener ... listeners) {
        for (ProgressListener l : listeners) {
            this.add(l);
        }
    }

    public boolean add(ProgressListener l) {
        return this.listeners.add(l);
    }

    public boolean remove(ProgressListener l) {
        return this.listeners.remove(l);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public int size() {
        return this.listeners.size();
    }

    public ProgressListener[] getListeners() {
        return this.listeners.toArray(new ProgressListener[this.listeners.size()]);
    }

    @Override
    public void showProgress(int progress) {
        for (ProgressListener l : this.getListeners()) {
            l.showProgress(progress);
        }
    }

    @Override
    public void showProgress(long inputSize, long outputSize) {
        for (ProgressListener l : this.getListeners()) {
            l.showProgress(inputSize, outputSize);
        }
    }

    @Override
    public void setMaximum(long maximum) {
        for (ProgressListener l : this.getListeners()) {
            l.setMaximum(maximum);
        }
    }

    @Override
    public void setMaximum(long inputMaximum, long outputMaximum) {
        for (ProgressListener l : this.getListeners()) {
            l.setMaximum(inputMaximum, outputMaximum);
        }
    }
}

