/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.unit;

public enum TemperatureUnit {
    CELSIUS{

        @Override
        public String getName() {
            return "Celsius";
        }

        @Override
        public double convert(double t, TemperatureUnit u) {
            return u.toCelsius(t);
        }

        @Override
        public double toCelsius(double t) {
            return t;
        }

        @Override
        public double toFahrenheit(double t) {
            return t * 1.8 + 32.0;
        }

        @Override
        public double toKelvin(double t) {
            return t + 273.15;
        }

        @Override
        public double toNewton(double t) {
            return t * 0.33;
        }

        @Override
        public double toRankine(double t) {
            return t * 9.0 / 5.0 + 491.67;
        }

        @Override
        public double toReaumur(double t) {
            return t * 4.0 / 5.0;
        }

        @Override
        public double toRomer(double t) {
            return t * 21.0 / 40.0 + 7.5;
        }

        @Override
        public double toDelisle(double t) {
            return (100.0 - t) * 3.0 / 2.0;
        }

        @Override
        public String unitString() {
            return "\u00b0C";
        }

        @Override
        public char unitChar() {
            return '\u2103';
        }

        @Override
        public boolean isStandard() {
            return true;
        }
    }
    ,
    DELISLE{

        @Override
        public String getName() {
            return "Delisle";
        }

        @Override
        public double convert(double t, TemperatureUnit u) {
            return u.toDelisle(t);
        }

        @Override
        public double toCelsius(double t) {
            return 100.0 - t * 2.0 / 3.0;
        }

        @Override
        public double toDelisle(double t) {
            return t;
        }

        @Override
        public String unitString() {
            return "\u00b0De";
        }

        @Override
        public boolean isStandard() {
            return false;
        }
    }
    ,
    FAHRENHEIT{

        @Override
        public String getName() {
            return "Fahrenheit";
        }

        @Override
        public double convert(double t, TemperatureUnit u) {
            return u.toFahrenheit(t);
        }

        @Override
        public double toCelsius(double t) {
            return (t - 32.0) / 1.8;
        }

        @Override
        public double toFahrenheit(double t) {
            return t;
        }

        @Override
        public String unitString() {
            return "\u00b0F";
        }

        @Override
        public char unitChar() {
            return '\u2109';
        }

        @Override
        public boolean isStandard() {
            return true;
        }
    }
    ,
    KELVIN{

        @Override
        public String getName() {
            return "Kelvin";
        }

        @Override
        public double convert(double t, TemperatureUnit u) {
            return u.toKelvin(t);
        }

        @Override
        public double toCelsius(double t) {
            return t - 273.15;
        }

        @Override
        public double toKelvin(double t) {
            return t;
        }

        @Override
        public String unitString() {
            return "K";
        }

        @Override
        public char unitChar() {
            return '\u212a';
        }

        @Override
        public boolean isStandard() {
            return true;
        }
    }
    ,
    NEWTON{

        @Override
        public String getName() {
            return "Newton";
        }

        @Override
        public double convert(double t, TemperatureUnit u) {
            return u.toNewton(t);
        }

        @Override
        public double toCelsius(double t) {
            return t * 100.0 / 33.0;
        }

        @Override
        public double toNewton(double t) {
            return t;
        }

        @Override
        public String unitString() {
            return "\u00b0N";
        }

        @Override
        public char unitChar() {
            return '?';
        }

        @Override
        public boolean isStandard() {
            return false;
        }
    }
    ,
    RANKINE{

        @Override
        public String getName() {
            return "Rankine";
        }

        @Override
        public double convert(double t, TemperatureUnit u) {
            return u.toRankine(t);
        }

        @Override
        public double toCelsius(double t) {
            return KELVIN.toCelsius(this.toKelvin(t));
        }

        @Override
        public double toFahrenheit(double t) {
            return t - 459.67;
        }

        @Override
        public double toKelvin(double t) {
            return t / 1.8;
        }

        @Override
        public double toRankine(double t) {
            return t;
        }

        @Override
        public String unitString() {
            return "\u00b0Ra";
        }

        @Override
        public boolean isStandard() {
            return false;
        }
    }
    ,
    REAUMUR{

        @Override
        public String getName() {
            return "R\u00e9aumur";
        }

        @Override
        public double convert(double t, TemperatureUnit u) {
            return u.toReaumur(t);
        }

        @Override
        public double toCelsius(double t) {
            return t * 5.0 / 4.0;
        }

        @Override
        public double toReaumur(double t) {
            return t;
        }

        @Override
        public String unitString() {
            return "\u00b0R\u00e9";
        }

        @Override
        public boolean isStandard() {
            return false;
        }
    }
    ,
    ROMER{

        @Override
        public String getName() {
            return "R\u00f8mer";
        }

        @Override
        public double convert(double t, TemperatureUnit u) {
            return u.toRomer(t);
        }

        @Override
        public double toCelsius(double t) {
            return (t - 7.5) * 40.0 / 21.0;
        }

        @Override
        public double toRomer(double t) {
            return t;
        }

        @Override
        public String unitString() {
            return "\u00b0R\u00f8";
        }

        @Override
        public boolean isStandard() {
            return false;
        }
    };

    public static final char UNICODE_UNSUPPORTED = '?';

    public double convert(double sourceTemperature, TemperatureUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public double toCelsius(double t) {
        throw new AbstractMethodError();
    }

    public double toFahrenheit(double t) {
        return CELSIUS.toFahrenheit(this.toCelsius(t));
    }

    public double toKelvin(double t) {
        return CELSIUS.toKelvin(this.toCelsius(t));
    }

    public double toRankine(double t) {
        return CELSIUS.toRankine(this.toCelsius(t));
    }

    public double toNewton(double t) {
        return CELSIUS.toNewton(this.toCelsius(t));
    }

    public double toReaumur(double t) {
        return CELSIUS.toReaumur(this.toCelsius(t));
    }

    public double toRomer(double t) {
        return CELSIUS.toRomer(this.toCelsius(t));
    }

    public double toDelisle(double t) {
        return CELSIUS.toDelisle(this.toCelsius(t));
    }

    public String unitString() {
        throw new AbstractMethodError();
    }

    public char unitChar() {
        return '?';
    }

    public final String toString(double t) {
        return TemperatureUnit.toString(t, this);
    }

    public static final String toString(double t, TemperatureUnit unit) {
        return String.format("%.2f%s", t, unit.unitString());
    }

    public final String toUnicodeString(double t) {
        return TemperatureUnit.toUnicodeString(t, this);
    }

    public static final String toUnicodeString(double t, TemperatureUnit unit) {
        if (unit.unitChar() == '?') {
            return TemperatureUnit.toString(t, unit);
        }
        return String.format("%.2f%c", t, Character.valueOf(unit.unitChar()));
    }

    public boolean isStandard() {
        throw new AbstractMethodError();
    }

    public final boolean isDisused() {
        return !this.isStandard();
    }

    public String getName() {
        throw new AbstractMethodError();
    }
}

