/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.string;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternReplacer {
    public static final String DEFAULT_PATTERN = "(@@(.*?)@@)";
    private Pattern pattern;
    private Map<String, String> values;
    private Replacer customReplacer;

    public PatternReplacer() {
        this(DEFAULT_PATTERN, null);
    }

    public PatternReplacer(String pattern) {
        this(pattern, null);
    }

    public PatternReplacer(Replacer replacer) {
        this(DEFAULT_PATTERN, replacer);
    }

    public PatternReplacer(String pattern, Replacer replacer) {
        this.customReplacer = replacer;
        this.pattern = Pattern.compile(pattern);
    }

    public String replaceString(String string, Map<String, String> values) {
        this.setValues(values);
        return this.replaceString(string);
    }

    public String replaceString(String string) {
        return ((Object)this.replace(string)).toString();
    }

    public StringBuffer replaceStringBuffer(StringBuffer sb, Map<String, String> values) {
        this.setValues(values);
        return this.replaceStringBuffer(sb);
    }

    public StringBuffer replaceStringBuffer(StringBuffer sb) {
        return (StringBuffer)this.replace(sb);
    }

    public StringBuilder replaceStringBuilder(StringBuilder sb, Map<String, String> values) {
        this.setValues(values);
        return this.replaceStringBuilder(sb);
    }

    public StringBuilder replaceStringBuilder(StringBuilder sb) {
        return new StringBuilder(this.replace(sb));
    }

    public Map<String, String> replaceMap(Map<String, String> map, Map<String, String> values) {
        this.setValues(values);
        return this.replaceMap(map);
    }

    public Map<String, String> replaceMap(Map<String, String> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            newMap.put(entry.getKey(), ((Object)this.replace(entry.getValue())).toString());
        }
        return newMap;
    }

    public CharSequence replace(CharSequence seq, Map<String, String> values) {
        this.setValues(values);
        return this.replace(seq);
    }

    public CharSequence replace(CharSequence seq) {
        StringBuffer sb = new StringBuffer();
        Matcher mat = this.pattern.matcher(seq);
        while (mat.find()) {
            mat.appendReplacement(sb, this.replace(mat, this.values));
        }
        mat.appendTail(sb);
        return sb;
    }

    private String replace(Matcher matcher, Map<String, String> values) {
        String key;
        String ret = "";
        ret = this.getCustomReplacer() == null ? (values.containsKey(key = matcher.group(2)) ? values.get(key).toString() : "") : this.getCustomReplacer().lookupReplacement(matcher, values);
        return ret;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void setValues(Map<String, String> values) {
        this.values = values;
    }

    public Replacer getCustomReplacer() {
        return this.customReplacer;
    }

    public static interface Replacer {
        public String lookupReplacement(Matcher var1, Map<String, String> var2);
    }
}

