/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.mime;

import java.util.HashMap;
import java.util.Map;
import uk.org.retep.util.mime.DocumentType;

public enum ContentType {
    MATHEMATICA("application/mathematica", DocumentType.APPLICATION, "nb"),
    MS_WORD("application/msword", DocumentType.DOCUMENT, "doc", "dot"),
    MS_EXCEL("application/vnd.ms-excel", DocumentType.DOCUMENT, "xls", "xlb", "xlt"),
    MS_POWERPOINT("application/vnd.ms-powerpoint", DocumentType.DOCUMENT, "ppt", "pps"),
    BIN("application/octet-stream", DocumentType.APPLICATION, "bin"),
    PGP("application/pgp-keys", DocumentType.APPLICATION, "key"),
    PGP_SIGNATURE("application/pgp-signature", DocumentType.APPLICATION, "pgp"),
    DOC_PDF("application/pdf", DocumentType.DOCUMENT, "pdf"),
    DOC_POSTSCRIPT("application/postscript", DocumentType.DOCUMENT, "ps", "ai", "eps"),
    DOC_DVI("application/x-dvi", DocumentType.DOCUMENT, "dvi"),
    DOC_LATEX("application/x-latex", DocumentType.DOCUMENT, "latex"),
    DOC_TEX("text/x-tex", DocumentType.DOCUMENT, "tex", "ltx", "sty", "cls"),
    JAVA_SERIALIZED("application/x-java-serialized-object", DocumentType.APPLICATION, "ser"),
    LANG_C_HEADER("text/x-chdr", DocumentType.SOURCE, "h"),
    LANG_C_SOURCE("text/x-csrc", DocumentType.SOURCE, "c"),
    LANG_CPP_HEADER("text/x-c++hdr", DocumentType.SOURCE, "h++", "hpp", "hxx", "hh"),
    LANG_CPP_SOURCE("text/x-c++src", DocumentType.SOURCE, "c++", "cpp", "cxx", "cc"),
    LANG_JAVA("text/x-java", DocumentType.SOURCE, "java"),
    LANG_JAVASCRIPT("application/x-javascript", DocumentType.SOURCE, "js"),
    LANG_PASCAL("text/x-pascal", DocumentType.SOURCE, "p", "pas"),
    LANG_PERL("application/x-perl", DocumentType.SOURCE, "pl", "pm"),
    LANG_PYTHON("text/x-python", DocumentType.SOURCE, "py"),
    ARCHIVE_JAR("application/x-java-archive", DocumentType.ARCHIVE, "jar"),
    ARCHIVE_LHA("application/x-lha", DocumentType.ARCHIVE, "lha"),
    ARCHIVE_LZH("application/x-lzh", DocumentType.ARCHIVE, "lzh"),
    ARCHIVE_LZX("application/x-lzx", DocumentType.ARCHIVE, "lzx"),
    ARCHIVE_MAC("application/mac-binhex40", DocumentType.ARCHIVE, "hqx"),
    ARCHIVE_SHAR("application/x-shar", DocumentType.ARCHIVE, "shar"),
    ARCHIVE_RAR("application/rar", DocumentType.ARCHIVE, "rar"),
    ARCHIVE_STUFFIT("application/x-stuffit", DocumentType.ARCHIVE, "sit"),
    ARCHIVE_TAR("application/x-tar", DocumentType.ARCHIVE, "tar"),
    ARCHIVE_ZIP("application/zip", DocumentType.ARCHIVE, "zip"),
    AUDIO_AU("audio/basic", DocumentType.APPLICATION, "au", "snd"),
    AUDIO_GSM("audio/x-gsm", DocumentType.APPLICATION, "gsm"),
    AUDIO_MIDI("audio/midi", DocumentType.APPLICATION, "mid", "midi", "kar"),
    AUDIO_MPEG("audio/mpeg", DocumentType.APPLICATION, "mp3", "mpga", "mpega", "mp2", "m4a"),
    AUDIO_MPEG_URL("audio/x-mpegurl", DocumentType.APPLICATION, "m3u"),
    AUDIO_REAL("audio/x-realaudio", DocumentType.APPLICATION, "ra"),
    AUDIO_REAL2("audio/x-pn-realaudio", DocumentType.APPLICATION, "rm", "ram"),
    AUDIO_WAV("audio/x-wav", DocumentType.APPLICATION, "wav"),
    AUDIO_WAX("audio/x-ms-wax", DocumentType.APPLICATION, "wax"),
    AUDIO_WMA("audio/x-ms-wma", DocumentType.APPLICATION, "wma"),
    VIDEO_DL("video/dl", DocumentType.APPLICATION, "dl"),
    VIDEO_DV("video/x-dv", DocumentType.APPLICATION, "dv", "dif"),
    VIDEO_FLI("video/fli", DocumentType.APPLICATION, "fli"),
    VIDEO_GL("video/gl", DocumentType.APPLICATION, "gl"),
    VIDEO_MPEG("video/mpeg", DocumentType.APPLICATION, "mpg", "mpeg", "mpe", "mp4"),
    VIDEO_MPEG_URL("video/vnd.mpegurl", DocumentType.APPLICATION, "mxu"),
    VIDEO_QUICKTIME("video/quicktime", DocumentType.APPLICATION, "qt", "mov"),
    VIDEO_WM("video/x-ms-wm", DocumentType.APPLICATION, "wm"),
    VIDEO_WMV("video/x-ms-wmv", DocumentType.APPLICATION, "wmv"),
    VIDEO_WMX("video/x-ms-wmx", DocumentType.APPLICATION, "wmx"),
    VIDEO_WVX("video/x-ms-wvx", DocumentType.APPLICATION, "wvx"),
    VIDEO_MOVIE("video/x-sgi-movie", DocumentType.APPLICATION, "movie"),
    IMAGE_BMP("image/bmp", DocumentType.IMAGE, "bmp"),
    IMAGE_GIF("image/gif", DocumentType.IMAGE, "gif"),
    IMAGE_ICON("image/x-icon", DocumentType.IMAGE, "ico"),
    IMAGE_IEF("image/ief", DocumentType.IMAGE, "ief"),
    IMAGE_JNG("image/x-jng", DocumentType.IMAGE, "jng"),
    IMAGE_JPEG("image/jpeg", DocumentType.IMAGE, "jpg", "jpeg", "jpe"),
    IMAGE_PBM("image/x-portable-bitmap", DocumentType.IMAGE, "pbm"),
    IMAGE_PCX("image/pcx", DocumentType.IMAGE, "pcx"),
    IMAGE_PGM("image/x-portable-graymap", DocumentType.IMAGE, "pgm"),
    IMAGE_PHOTOSHOP("image/x-photoshop", DocumentType.IMAGE, "psd"),
    IMAGE_PNG("image/png", DocumentType.IMAGE, "png"),
    IMAGE_PNM("image/x-portable-anymap", DocumentType.IMAGE, "pnm"),
    IMAGE_PPM("image/x-portable-pixmap", DocumentType.IMAGE, "ppm"),
    IMAGE_RASTER("image/x-cmu-raster", DocumentType.IMAGE, "ras"),
    IMAGE_RGB("image/x-rgb", DocumentType.IMAGE, "rgb"),
    IMAGE_SVG("image/svg+xml", DocumentType.IMAGE, "svg", "svgz"),
    IMAGE_TIFF("image/tiff", DocumentType.IMAGE, "tif", "tiff"),
    IMAGE_WBMP("image/vnd.wap.wbmp", DocumentType.IMAGE, "wbmp"),
    IMAGE_X_BITMAP("image/x-xbitmap", DocumentType.IMAGE, "xbm"),
    IMAGE_X_PIXMAP("image/x-xpixmap", DocumentType.IMAGE, "xpm"),
    TEXT_CALENDAR("text/calendar", DocumentType.DOCUMENT, "ical"),
    TEXT_CSV("text/comma-separated-values", DocumentType.DOCUMENT, "csv"),
    TEXT_CSS("text/css", DocumentType.DOCUMENT, "css"),
    TEXT_HTML("text/html", DocumentType.DOCUMENT, "html", "htm", "xhtml", "shtml"),
    TEXT_MATHML("text/mathml", DocumentType.DOCUMENT, "mml"),
    TEXT_PLAIN("text/plain", DocumentType.DOCUMENT, "txt", "asc", "text", "diff", "pot"),
    TEXT_RICHTEXT("text/rtf", DocumentType.DOCUMENT, "rtf"),
    TEXT_RICHTEXT2("text/richtext", DocumentType.DOCUMENT, "rtx"),
    TEXT_TSV("text/tab-separated-values", DocumentType.DOCUMENT, "tsv"),
    TEXT_WML("text/vnd.wap.wml", DocumentType.DOCUMENT, "wml"),
    TEXT_WMLSCRIPT("text/vnd.wap.wmlscript", DocumentType.DOCUMENT, "wmls"),
    TEXT_XML("text/xml", DocumentType.DOCUMENT, "xml", "xsl"),
    TEXT_XML_RSS("application/rss+xml", DocumentType.DOCUMENT, "rss"),
    RETEP_WIKI("text/wiki", DocumentType.DOCUMENT, "wiki");

    private String contentType;
    private String[] suffixes;
    private DocumentType documentType;
    private static Map<String, ContentType> mimeTypeMap;
    private static Map<String, ContentType> suffixMap;

    public static ContentType getMimeType(String mimeType) {
        ContentType ct;
        if (mimeTypeMap == null) {
            HashMap<String, ContentType> map = new HashMap<String, ContentType>();
            for (ContentType ct2 : ContentType.values()) {
                map.put(ct2.getMimeType(), ct2);
            }
            mimeTypeMap = map;
        }
        if ((ct = mimeTypeMap.get(mimeType)) == null) {
            throw new IllegalArgumentException("Unsupported mimeType " + mimeType);
        }
        return ct;
    }

    public static ContentType getSuffix(String suffix) {
        String trueSuffix;
        ContentType ct;
        if (suffixMap == null) {
            HashMap<String, ContentType> map = new HashMap<String, ContentType>();
            for (ContentType ct2 : ContentType.values()) {
                for (String key : ct2.getSuffices()) {
                    if (map.containsKey(key)) continue;
                    map.put(key, ct2);
                }
            }
            suffixMap = map;
        }
        if ((ct = suffixMap.get(trueSuffix = suffix.contains(".") ? suffix.substring(suffix.lastIndexOf(46) + 1) : suffix)) == null) {
            throw new IllegalArgumentException("Unsupported file suffix " + trueSuffix);
        }
        return ct;
    }

    private ContentType(String contentType, DocumentType documentType, String ... suffixes) {
        this.contentType = contentType;
        this.suffixes = suffixes;
        this.documentType = documentType;
    }

    public String getMimeType() {
        return this.contentType;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String[] getSuffices() {
        return this.suffixes;
    }

    public String getDefaultSuffix() {
        if (this.suffixes == null || this.suffixes.length == 0) {
            return null;
        }
        return this.suffixes[0];
    }
}

