/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.queue;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import uk.org.retep.util.thread.DelayedRunnable;

public class DelayedBlockingQueue
extends AbstractCollection<Runnable>
implements BlockingQueue<Runnable> {
    private final ReentrantLock lock = new ReentrantLock();
    private final DelayQueue<DelayedRunnable> dq;

    public DelayedBlockingQueue() {
        this(new DelayQueue());
    }

    public DelayedBlockingQueue(DelayQueue<? extends DelayedRunnable> dq) {
        this.dq = dq;
    }

    @Override
    public Runnable poll() {
        return (Runnable)this.dq.poll();
    }

    @Override
    public Runnable peek() {
        return (Runnable)this.dq.peek();
    }

    @Override
    public Runnable take() throws InterruptedException {
        return (Runnable)this.dq.take();
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (Runnable)this.dq.poll(timeout, unit);
    }

    @Override
    public boolean add(Runnable x) {
        assert (this.offer(x));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Runnable x) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (!(x instanceof DelayedRunnable)) {
                throw new ClassCastException("Runnable does not implement DelayedRunnable interface");
            }
            if (this.dq.contains(x)) {
                this.dq.remove(x);
            }
            boolean bl = this.dq.offer((DelayedRunnable)((Delayed)DelayedRunnable.class.cast(x)));
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void put(Runnable x) {
        this.offer(x);
    }

    @Override
    public boolean offer(Runnable x, long timeout, TimeUnit unit) {
        return this.offer(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable remove() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Runnable runnable = (Runnable)this.dq.remove();
            return runnable;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable element() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Runnable runnable = (Runnable)this.dq.element();
            return runnable;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.dq.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super Runnable> c) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.dq.drainTo(c);
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.dq.drainTo(c, maxElements);
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return this.dq.remainingCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object x) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.dq.remove(x);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object x) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.dq.contains(x);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.dq.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dq.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.dq.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.dq.toArray(array);
    }

    @Override
    public Iterator<Runnable> iterator() {
        return new Iterator<Runnable>(){
            private Iterator<DelayedRunnable> it;
            {
                this.it = DelayedBlockingQueue.this.dq.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Runnable next() {
                return this.it.next();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                ReentrantLock lock = DelayedBlockingQueue.this.lock;
                lock.lock();
                try {
                    this.it.remove();
                }
                finally {
                    lock.unlock();
                }
            }
        };
    }
}

