/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import uk.org.retep.util.classloader.CachingClassLoader;
import uk.org.retep.util.collections.CollectionUtils;
import uk.org.retep.util.collections.EmptyIterator;

public abstract class CachingInputStreamClassLoader
extends CachingClassLoader {
    public CachingInputStreamClassLoader() {
    }

    public CachingInputStreamClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public final Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> c = this.getClass(className);
            if (c == null) {
                try {
                    byte[] data = this.readBytes(className);
                    c = this.defineClass(className, data, 0, data.length);
                    this.putClass(className, c);
                }
                catch (IOException ioe) {
                    throw new ClassNotFoundException("Failed to read " + className, ioe);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        catch (Exception e) {
            throw new ClassNotFoundException(e.toString(), e);
        }
    }

    protected abstract byte[] readBytes(String var1) throws IOException;

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        URL url = this.findResource(name);
        if (url == null) {
            return new EmptyIterator<URL>();
        }
        return CollectionUtils.singletonEnumeration(url);
    }
}

