/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import uk.org.retep.util.collections.EmptyIterator;

@Deprecated
public class TreeNode<T>
implements Collection<T> {
    private LinkedList<TreeNode<T>> children;
    private TreeNode<T> parent;
    private T object;

    public TreeNode() {
        this(null);
    }

    public TreeNode(T object) {
        this(object, null);
    }

    public TreeNode(T aObject, TreeNode aParent) {
        this.setObject(aObject);
        this.addToParent(aParent);
    }

    public T getObject() {
        return this.object;
    }

    public T setObject(T aObject) {
        T oldObject = this.object;
        this.object = aObject;
        return oldObject;
    }

    public boolean addChild(TreeNode<T> node) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        if (!this.children.contains(node)) {
            this.children.add(node);
            node.addToParent(this);
            return true;
        }
        return false;
    }

    public void addToParent(TreeNode aParent) {
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.parent = aParent;
        if (aParent != null) {
            this.parent.addChild(this);
        }
    }

    public TreeNode findTreeNodeContaining(Object o) {
        for (TreeNode node : this) {
            if (node.object.equals(o)) {
                return node;
            }
            if (node.isEmpty() || (node = node.findTreeNodeContaining(o)) == null) continue;
            return node;
        }
        return null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public TreeNode<T> getRoot() {
        TreeNode<T> node = this;
        while (!node.isRoot()) {
            node = node.getParent();
        }
        return node;
    }

    public TreeNode<T>[] getTreeNodePath() {
        ArrayList<TreeNode<T>> list = new ArrayList<TreeNode<T>>();
        TreeNode<T> node = this;
        while (!node.isRoot()) {
            list.add(0, node);
            node = node.getParent();
        }
        return list.toArray(new TreeNode[list.size()]);
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof TreeNode) {
            return this.addChild((TreeNode)o);
        }
        return this.addChild(new TreeNode<Object>(o));
    }

    @Override
    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            changed |= this.add(it.next());
        }
        return changed;
    }

    @Override
    public void clear() {
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            this.remove(it.next());
        }
    }

    @Override
    public boolean contains(Object o) {
        for (TreeNode node : this) {
            if (!o.equals(node) && !o.equals(node.object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        boolean flag;
        Iterator it = c.iterator();
        for (flag = true; flag && it.hasNext(); flag &= this.contains(it.next())) {
        }
        return flag;
    }

    @Override
    public boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        if (this.contains(o)) {
            if (o instanceof TreeNode) {
                TreeNode node = (TreeNode)o;
                this.children.remove(node);
                node.addToParent(null);
            } else {
                for (TreeNode node : this) {
                    if (!node.object.equals(o)) continue;
                    this.children.remove(node);
                    node.addToParent(null);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            changed |= this.remove(it.next());
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean changed = false;
        for (TreeNode node : this) {
            if (c.contains(node) || c.contains(node.object)) continue;
            changed |= this.remove(node);
        }
        return changed;
    }

    @Override
    public int size() {
        return this.isEmpty() ? 0 : this.children.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray((E[])new Object[this.size()]);
    }

    @Override
    public <E> E[] toArray(E[] a) {
        ArrayList<T> temp = new ArrayList<T>();
        if (!this.isEmpty()) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                temp.add(((TreeNode)it.next()).getObject());
            }
        }
        return temp.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.isEmpty() ? new EmptyIterator() : new ChildIterator(this.children.iterator());
    }

    private class ChildIterator<T>
    implements Iterator<T> {
        private Iterator<TreeNode<T>> iterator;

        public ChildIterator(Iterator<TreeNode<T>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next().getObject();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

