/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.thread;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import uk.org.retep.util.thread.GlobalThreadPool;

public class GlobalScheduledThreadPoolExecutor
implements Executor,
ExecutorService,
ScheduledExecutorService {
    private static final GlobalScheduledThreadPoolExecutor INSTANCE = new GlobalScheduledThreadPoolExecutor();
    private ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, GlobalThreadPool.createDaemonThreadFactory("GlobalScheduledThreadPoolExecutor"));

    public static GlobalScheduledThreadPoolExecutor getInstance() {
        return INSTANCE;
    }

    private GlobalScheduledThreadPoolExecutor() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                GlobalScheduledThreadPoolExecutor.this.executor.shutdown();
            }
        });
    }

    @Override
    public void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public boolean remove(Runnable task) {
        return this.executor.remove(task);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executor.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.executor.schedule(task, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(command, initialDelay, period, unit);
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.executor.getContinueExistingPeriodicTasksAfterShutdownPolicy();
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executor.getExecuteExistingDelayedTasksAfterShutdownPolicy();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException("shutdown not permitted");
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("shutdownNow not permitted");
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(task, result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }
}

