/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.logging;

import java.io.IOException;
import java.io.InputStream;
import uk.org.retep.logging.Log;
import uk.org.retep.logging.LogFactory;
import uk.org.retep.util.string.StringUtils;

public class InputStreamLogger
extends InputStream {
    private static int counter = 0;
    private InputStream in;
    private Log log;
    private char[] logBuf = new char[16];
    private int logBufPos = 0;
    private long logBufTotal = 0L;

    public InputStreamLogger(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("InputStream may not be null");
        }
        this.in = in;
        this.log = LogFactory.getLog("Input_" + ++counter, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        char[] cArray = this.logBuf;
        synchronized (this.logBuf) {
            if (this.logBufPos > 0) {
                int i;
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("%06x ", this.logBufTotal));
                int s = Math.min(this.logBufPos, this.logBuf.length);
                for (i = 0; i < s; ++i) {
                    sb.append(this.logBuf[i] > '\u001f' && this.logBuf[i] < '\u007f' ? this.logBuf[i] : (char)'.');
                }
                for (i = s; i < this.logBuf.length; ++i) {
                    sb.append(' ');
                }
                sb.append(" :");
                for (i = 0; i < s; ++i) {
                    char v = this.logBuf[i];
                    sb.append(StringUtils.encodeHex(v >>> 4 & 0xF));
                    sb.append(StringUtils.encodeHex(v >>> 0 & 0xF));
                    sb.append(' ');
                }
                this.log.info(sb);
                this.logBufTotal += (long)this.logBufPos;
                this.logBufPos = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int add(int c) {
        char[] cArray = this.logBuf;
        synchronized (this.logBuf) {
            if (c > -1) {
                this.logBuf[this.logBufPos++] = (char)c;
                if (this.logBufPos >= this.logBuf.length) {
                    this.dump();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return c;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
        try {
            return this.add(this.in.read());
        }
        catch (IOException ex) {
            this.log.error((Object)ex.getMessage(), ex);
            throw ex;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            return this.read(b, 0, b.length);
        }
        catch (IOException ex) {
            this.log.error((Object)ex.getMessage(), ex);
            throw ex;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
        this.log.info("read( %d, %d )", off, len);
        int l = this.in.read(b, off, len);
        for (int i = 0; i < l; ++i) {
            this.add(b[off + i]);
        }
        this.dump();
        return l;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.dump();
                this.in.close();
                this.in = null;
            }
            catch (IOException ex) {
                this.log.error((Object)ex.getMessage(), ex);
                throw ex;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
        try {
            int i = this.in.available();
            this.log.info("available() = %d", i);
            return i;
        }
        catch (IOException ex) {
            this.log.error((Object)ex.getMessage(), ex);
            throw ex;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
        this.log.info("skip(%d)", (int)n);
        try {
            return this.in.skip(n);
        }
        catch (IOException ex) {
            this.log.error((Object)ex.getMessage(), ex);
            throw ex;
        }
    }

    @Override
    public void mark(int readlimit) {
        if (this.in == null) {
            throw new IllegalStateException("Stream closed");
        }
        this.log.info("mark(%d)", readlimit);
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        if (this.in == null) {
            throw new IllegalStateException("Stream closed");
        }
        return this.in.markSupported();
    }

    @Override
    public void reset() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
        try {
            this.in.reset();
        }
        catch (IOException ex) {
            this.log.error((Object)ex.getMessage(), ex);
            throw ex;
        }
    }
}

