/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class AbstractTreeNode<T extends AbstractTreeNode> {
    private int hashCode;
    private int level = 0;
    private int depth;
    private List<T> children = new ArrayList<T>();
    private T parent = null;

    public final int getLevel() {
        return this.level;
    }

    protected void setLevel(int level) {
        this.level = level;
        for (AbstractTreeNode node : this.children) {
            node.setLevel(level + 1);
        }
    }

    public final int getDepth() {
        if (!this.isRoot()) {
            return ((AbstractTreeNode)this.getRoot()).getDepth();
        }
        if (this.depth == 0) {
            this.depth = this.getDepth(1);
        }
        return this.depth;
    }

    private int getDepth(int depth) {
        for (AbstractTreeNode node : this.children) {
            depth = Math.max(depth, node.getDepth(depth));
        }
        return Math.max(depth, this.level + 1);
    }

    public final Collection<T> getChildren() {
        return this.children;
    }

    public final boolean addChild(T node) {
        if (((AbstractTreeNode)node).getParent() != null) {
            ((AbstractTreeNode)((AbstractTreeNode)node).getParent()).removeChild(node);
        }
        boolean r = this.children.add(node);
        super.setParent((AbstractTreeNode)this);
        ((AbstractTreeNode)node).setLevel(this.getLevel() + 1);
        this.childModified();
        return r;
    }

    public final <T extends AbstractTreeNode> T removeChild(T node) {
        if (this.children.contains(node)) {
            this.children.remove(node);
            super.setParent(null);
            this.setLevel(0);
            this.childModified();
            return node;
        }
        return null;
    }

    private final void setParent(T node) {
        this.parent = node;
    }

    public final T getParent() {
        return this.parent;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public final boolean isLeaf() {
        return this.children.isEmpty();
    }

    public final T getFirstChild() {
        return (T)(this.children.isEmpty() ? null : (AbstractTreeNode)this.children.get(0));
    }

    public final T getLastChild() {
        return (T)(this.children.isEmpty() ? null : (AbstractTreeNode)this.children.get(this.children.size() - 1));
    }

    public final int size() {
        return this.children.size();
    }

    public final T getRoot() {
        return (T)(this.isRoot() ? this : this.getRoot());
    }

    public T getChild(int index) {
        for (AbstractTreeNode node : this.getChildren()) {
            if (--index >= 0) continue;
            return (T)node;
        }
        return null;
    }

    public int indexOfChild(T node) {
        return this.children.indexOf(node);
    }

    public int getIndex() {
        return this.isRoot() ? 0 : this.getParent().indexOfChild((AbstractTreeNode)this);
    }

    protected final void childModified() {
        this.hashCode = 0;
        this.depth = 0;
        if (this.parent != null) {
            ((AbstractTreeNode)this.parent).childModified();
        }
    }

    protected abstract int hashCodeImpl();

    public final int hashCode() {
        if (this.hashCode == 0) {
            int c = this.hashCodeImpl();
            for (AbstractTreeNode node : this.children) {
                c = c * 31 + node.hashCode();
            }
            this.hashCode = c;
        }
        return this.hashCode;
    }

    public final String toString() {
        return this.append(new StringBuilder()).toString();
    }

    protected abstract void appendImpl(StringBuilder var1);

    public final StringBuilder append(StringBuilder sb) {
        char[] indent = new char[this.level + 1];
        Arrays.fill(indent, ' ');
        indent[0] = 10;
        sb.append(indent).append("( ");
        this.appendImpl(sb);
        if (this.children.isEmpty()) {
            sb.append(" )");
        } else {
            for (AbstractTreeNode node : this.children) {
                node.append(sb);
            }
            sb.append(indent).append(')');
        }
        return sb;
    }
}

