/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import uk.org.retep.util.io.tar.TarEntry;
import uk.org.retep.util.io.tar.TarInputStream;

public class TarEntryEnumerator
implements Enumeration {
    private TarInputStream tis = null;
    private boolean eof = false;
    private TarEntry readAhead = null;

    public TarEntryEnumerator(TarInputStream tis) {
        this.tis = tis;
        this.eof = false;
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.eof && this.readAhead == null) {
            throw new NoSuchElementException();
        }
        TarEntry rc = null;
        if (this.readAhead != null) {
            rc = this.readAhead;
            this.readAhead = null;
        } else {
            rc = this.getNext();
        }
        return rc;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.eof) {
            return false;
        }
        boolean rc = false;
        this.readAhead = this.getNext();
        if (this.readAhead != null) {
            rc = true;
        }
        return rc;
    }

    private TarEntry getNext() {
        TarEntry rc = null;
        try {
            rc = this.tis.getNextEntry();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (rc == null) {
            this.eof = true;
        }
        return rc;
    }
}

