/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import uk.org.retep.util.io.tar.InvalidHeaderException;
import uk.org.retep.util.io.tar.TarEntry;

public class FastTarStream {
    private boolean debug = false;
    private boolean hasHitEOF = false;
    private TarEntry currEntry = null;
    private InputStream inStream = null;
    private int recordSize = 512;

    public FastTarStream(InputStream in) {
        this(in, 512);
    }

    public FastTarStream(InputStream in, int recordSize) {
        this.inStream = in;
        this.hasHitEOF = false;
        this.currEntry = null;
        this.recordSize = recordSize;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public TarEntry getNextEntry() throws IOException {
        int numRead;
        int numRecords;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null && this.currEntry.getSize() > 0L && (numRecords = ((int)this.currEntry.getSize() + (this.recordSize - 1)) / this.recordSize) > 0) {
            this.inStream.skip(numRecords * this.recordSize);
        }
        byte[] headerBuf = new byte[this.recordSize];
        int bufIndex = 0;
        for (int bytesNeeded = this.recordSize; bytesNeeded > 0; bytesNeeded -= numRead) {
            numRead = this.inStream.read(headerBuf, bufIndex, bytesNeeded);
            if (numRead == -1) {
                this.hasHitEOF = true;
                break;
            }
            bufIndex += numRead;
        }
        if (!this.hasHitEOF) {
            this.hasHitEOF = true;
            for (int i = 0; i < headerBuf.length; ++i) {
                if (headerBuf[i] == 0) continue;
                this.hasHitEOF = false;
                break;
            }
        }
        if (this.hasHitEOF) {
            this.currEntry = null;
        } else {
            try {
                this.currEntry = new TarEntry(headerBuf);
                if (this.debug) {
                    byte[] by = new byte[headerBuf.length];
                    for (int i = 0; i < headerBuf.length; ++i) {
                        by[i] = headerBuf[i] == 0 ? 20 : headerBuf[i];
                    }
                    String s = new String(by);
                    System.out.println("\n" + s);
                }
                if (headerBuf[257] != 117 || headerBuf[258] != 115 || headerBuf[259] != 116 || headerBuf[260] != 97 || headerBuf[261] != 114) {
                    throw new InvalidHeaderException("header magic is not'ustar', but '" + headerBuf[257] + headerBuf[258] + headerBuf[259] + headerBuf[260] + headerBuf[261] + "', or (dec) " + headerBuf[257] + ", " + headerBuf[258] + ", " + headerBuf[259] + ", " + headerBuf[260] + ", " + headerBuf[261]);
                }
            }
            catch (InvalidHeaderException ex) {
                this.currEntry = null;
                throw ex;
            }
        }
        return this.currEntry;
    }

    public static void main(String[] args) {
        boolean debug = false;
        InputStream in = null;
        String fileName = args[0];
        try {
            TarEntry entry;
            int idx = 0;
            if (args.length > 0) {
                if (args[idx].equals("-d")) {
                    debug = true;
                    ++idx;
                }
                in = args[idx].endsWith(".gz") || args[idx].endsWith(".tgz") ? new GZIPInputStream(new FileInputStream(args[idx])) : new FileInputStream(args[idx]);
            } else {
                in = System.in;
            }
            FastTarStream fts = new FastTarStream(in);
            fts.setDebug(debug);
            int nameWidth = 56;
            int sizeWidth = 9;
            int userWidth = 8;
            StringBuffer padBuf = new StringBuffer(128);
            while ((entry = fts.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    System.out.print("D ");
                    padBuf.setLength(0);
                    padBuf.append(entry.getName());
                    padBuf.setLength(padBuf.length() - 1);
                    if (padBuf.length() > nameWidth) {
                        padBuf.setLength(nameWidth);
                    }
                    while (padBuf.length() < nameWidth) {
                        padBuf.append('_');
                    }
                    padBuf.append('_');
                    System.out.print(padBuf.toString());
                    padBuf.setLength(0);
                    while (padBuf.length() < sizeWidth) {
                        padBuf.insert(0, '_');
                    }
                    padBuf.append(' ');
                    System.out.print(padBuf.toString());
                    padBuf.setLength(0);
                    padBuf.append(entry.getUserName());
                    if (padBuf.length() > userWidth) {
                        padBuf.setLength(userWidth);
                    }
                    while (padBuf.length() < userWidth) {
                        padBuf.append(' ');
                    }
                    System.out.print(padBuf.toString());
                } else {
                    System.out.print("F ");
                    padBuf.setLength(0);
                    padBuf.append(entry.getName());
                    if (padBuf.length() > nameWidth) {
                        padBuf.setLength(nameWidth);
                    }
                    while (padBuf.length() < nameWidth) {
                        padBuf.append(' ');
                    }
                    padBuf.append(' ');
                    System.out.print(padBuf.toString());
                    padBuf.setLength(0);
                    padBuf.append(entry.getSize());
                    if (padBuf.length() > sizeWidth) {
                        padBuf.setLength(sizeWidth);
                    }
                    while (padBuf.length() < sizeWidth) {
                        padBuf.insert(0, ' ');
                    }
                    padBuf.append(' ');
                    System.out.print(padBuf.toString());
                    padBuf.setLength(0);
                    padBuf.append(entry.getUserName());
                    if (padBuf.length() > userWidth) {
                        padBuf.setLength(userWidth);
                    }
                    while (padBuf.length() < userWidth) {
                        padBuf.append(' ');
                    }
                    System.out.print(padBuf.toString());
                }
                System.out.println("");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

